/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler;

import java.io.InputStream;
import java.util.Properties;
import org.codehaus.commons.compiler.ICompilerFactory;

public final class CompilerFactoryFactory {
    private static ICompilerFactory defaultCompilerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICompilerFactory getDefaultCompilerFactory() throws Exception {
        if (defaultCompilerFactory == null) {
            Properties properties = new Properties();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org.codehaus.commons.compiler.properties");
            if (is == null) {
                throw new ClassNotFoundException("No implementation of org.codehaus.commons.compiler is on the class path");
            }
            try {
                properties.load(is);
            }
            finally {
                is.close();
            }
            String compilerFactoryClassName = properties.getProperty("compilerFactory");
            defaultCompilerFactory = CompilerFactoryFactory.getCompilerFactory(compilerFactoryClassName);
        }
        return defaultCompilerFactory;
    }

    public static ICompilerFactory getCompilerFactory(String compilerFactoryClassName) throws Exception {
        return (ICompilerFactory)Thread.currentThread().getContextClassLoader().loadClass(compilerFactoryClassName).newInstance();
    }
}

