/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.txn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.jute.CsvOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;

public class TxnHeader
implements Record {
    private long clientId;
    private int cxid;
    private long zxid;
    private long time;
    private int type;

    public TxnHeader() {
    }

    public TxnHeader(long clientId, int cxid, long zxid, long time, int type) {
        this.clientId = clientId;
        this.cxid = cxid;
        this.zxid = zxid;
        this.time = time;
        this.type = type;
    }

    public long getClientId() {
        return this.clientId;
    }

    public int getCxid() {
        return this.cxid;
    }

    public long getZxid() {
        return this.zxid;
    }

    public long getTime() {
        return this.time;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int m_) {
        this.type = m_;
    }

    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeLong(this.clientId, "clientId");
        a_.writeInt(this.cxid, "cxid");
        a_.writeLong(this.zxid, "zxid");
        a_.writeLong(this.time, "time");
        a_.writeInt(this.type, "type");
        a_.endRecord(this, tag);
    }

    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.clientId = a_.readLong("clientId");
        this.cxid = a_.readInt("cxid");
        this.zxid = a_.readLong("zxid");
        this.time = a_.readLong("time");
        this.type = a_.readInt("type");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeLong(this.clientId, "clientId");
            a_.writeInt(this.cxid, "cxid");
            a_.writeLong(this.zxid, "zxid");
            a_.writeLong(this.time, "time");
            a_.writeInt(this.type, "type");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof TxnHeader)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        TxnHeader peer = (TxnHeader)peer_;
        boolean ret = false;
        boolean bl = ret = this.clientId == peer.clientId;
        if (!ret) {
            return ret;
        }
        boolean bl2 = ret = this.cxid == peer.cxid;
        if (!ret) {
            return ret;
        }
        boolean bl3 = ret = this.zxid == peer.zxid;
        if (!ret) {
            return ret;
        }
        boolean bl4 = ret = this.time == peer.time;
        if (!ret) {
            return ret;
        }
        boolean bl5 = ret = this.type == peer.type;
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = (int)(this.clientId ^ this.clientId >>> 32);
        result = 37 * result + ret;
        ret = this.cxid;
        result = 37 * result + ret;
        ret = (int)(this.zxid ^ this.zxid >>> 32);
        result = 37 * result + ret;
        ret = (int)(this.time ^ this.time >>> 32);
        result = 37 * result + ret;
        ret = this.type;
        result = 37 * result + ret;
        return result;
    }
}

