/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.AuthFastLeaderElection;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.LeaderElectionBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.Observer;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumBean;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.zookeeper.server.quorum.RemotePeerBean;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuorumPeer
extends Thread
implements QuorumStats.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeer.class);
    QuorumBean jmxQuorumBean;
    LocalPeerBean jmxLocalPeerBean;
    LeaderElectionBean jmxLeaderElectionBean;
    QuorumCnxManager qcm;
    private ZKDatabase zkDb;
    public long start_fle;
    public long end_fle;
    private LearnerType learnerType = LearnerType.PARTICIPANT;
    protected Map<Long, QuorumServer> quorumPeers;
    private QuorumVerifier quorumConfig;
    private long myid;
    private volatile Vote currentVote;
    private volatile Vote bcVote;
    volatile boolean running = true;
    protected int tickTime;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected int initLimit;
    protected int syncLimit;
    protected boolean syncEnabled = true;
    protected volatile int tick;
    protected boolean quorumListenOnAllIPs = false;
    private ServerState state = ServerState.LOOKING;
    DatagramSocket udpSocket;
    private InetSocketAddress myQuorumAddr;
    private int electionType;
    Election electionAlg;
    ServerCnxnFactory cnxnFactory;
    private FileTxnSnapLog logFactory = null;
    private final QuorumStats quorumStats = new QuorumStats(this);
    ResponderThread responder;
    public Follower follower;
    public Leader leader;
    public Observer observer;
    private long acceptedEpoch = -1L;
    private long currentEpoch = -1L;

    public LearnerType getLearnerType() {
        return this.learnerType;
    }

    @Override
    public long getId() {
        return this.myid;
    }

    public synchronized Vote getCurrentVote() {
        return this.currentVote;
    }

    public synchronized void setCurrentVote(Vote v) {
        this.currentVote = v;
    }

    synchronized Vote getBCVote() {
        if (this.bcVote == null) {
            return this.currentVote;
        }
        return this.bcVote;
    }

    synchronized void setBCVote(Vote v) {
        this.bcVote = v;
    }

    public synchronized void setPeerState(ServerState newState) {
        this.state = newState;
    }

    public synchronized ServerState getPeerState() {
        return this.state;
    }

    public InetSocketAddress getQuorumAddress() {
        return this.myQuorumAddr;
    }

    public QuorumPeer() {
        super("QuorumPeer");
    }

    @Override
    public synchronized void start() {
        this.loadDataBase();
        this.cnxnFactory.start();
        this.startLeaderElection();
        super.start();
    }

    private void loadDataBase() {
        File updating = new File(this.getTxnFactory().getSnapDir(), "updatingEpoch");
        try {
            this.zkDb.loadDataBase();
            long lastProcessedZxid = this.zkDb.getDataTree().lastProcessedZxid;
            long epochOfZxid = ZxidUtils.getEpochFromZxid(lastProcessedZxid);
            try {
                this.currentEpoch = this.readLongFromFile("currentEpoch");
                if (epochOfZxid > this.currentEpoch && updating.exists()) {
                    LOG.info("{} found. The server was terminated after taking a snapshot but before updating current epoch. Setting current epoch to {}.", (Object)"updatingEpoch", (Object)epochOfZxid);
                    this.setCurrentEpoch(epochOfZxid);
                    if (!updating.delete()) {
                        throw new IOException("Failed to delete " + updating.toString());
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.currentEpoch = epochOfZxid;
                LOG.info("currentEpoch not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)this.currentEpoch);
                this.writeLongToFile("currentEpoch", this.currentEpoch);
            }
            if (epochOfZxid > this.currentEpoch) {
                throw new IOException("The current epoch, " + ZxidUtils.zxidToString(this.currentEpoch) + ", is older than the last zxid, " + lastProcessedZxid);
            }
            try {
                this.acceptedEpoch = this.readLongFromFile("acceptedEpoch");
            }
            catch (FileNotFoundException e) {
                this.acceptedEpoch = epochOfZxid;
                LOG.info("acceptedEpoch not found! Creating with a reasonable default of {}. This should only happen when you are upgrading your installation", (Object)this.acceptedEpoch);
                this.writeLongToFile("acceptedEpoch", this.acceptedEpoch);
            }
            if (this.acceptedEpoch < this.currentEpoch) {
                throw new IOException("The current epoch, " + ZxidUtils.zxidToString(this.currentEpoch) + " is less than the accepted epoch, " + ZxidUtils.zxidToString(this.acceptedEpoch));
            }
        }
        catch (IOException ie) {
            LOG.error("Unable to load database on disk", ie);
            throw new RuntimeException("Unable to run quorum server ", ie);
        }
    }

    public synchronized void startLeaderElection() {
        try {
            this.currentVote = new Vote(this.myid, this.getLastLoggedZxid(), this.getCurrentEpoch());
        }
        catch (IOException e) {
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
        for (QuorumServer p : this.getView().values()) {
            if (p.id != this.myid) continue;
            this.myQuorumAddr = p.addr;
            break;
        }
        if (this.myQuorumAddr == null) {
            throw new RuntimeException("My id " + this.myid + " not in the peer list");
        }
        if (this.electionType == 0) {
            try {
                this.udpSocket = new DatagramSocket(this.myQuorumAddr.getPort());
                this.responder = new ResponderThread();
                this.responder.start();
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
        this.electionAlg = this.createElectionAlgorithm(this.electionType);
    }

    public long getLastLoggedZxid() {
        if (!this.zkDb.isInitialized()) {
            this.loadDataBase();
        }
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
        return new Follower(this, new FollowerZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException {
        return new Leader(this, new LeaderZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Observer makeObserver(FileTxnSnapLog logFactory) throws IOException {
        return new Observer(this, new ObserverZooKeeperServer(logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb));
    }

    protected Election createElectionAlgorithm(int electionAlgorithm) {
        Election le = null;
        switch (electionAlgorithm) {
            case 0: {
                le = new LeaderElection(this);
                break;
            }
            case 1: {
                le = new AuthFastLeaderElection(this);
                break;
            }
            case 2: {
                le = new AuthFastLeaderElection(this, true);
                break;
            }
            case 3: {
                this.qcm = new QuorumCnxManager(this);
                QuorumCnxManager.Listener listener = this.qcm.listener;
                if (listener != null) {
                    listener.start();
                    le = new FastLeaderElection(this, this.qcm);
                    break;
                }
                LOG.error("Null listener when initializing cnx manager");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return le;
    }

    protected Election makeLEStrategy() {
        LOG.debug("Initializing leader election protocol...");
        if (this.getElectionType() == 0) {
            this.electionAlg = new LeaderElection(this);
        }
        return this.electionAlg;
    }

    protected synchronized void setLeader(Leader newLeader) {
        this.leader = newLeader;
    }

    protected synchronized void setFollower(Follower newFollower) {
        this.follower = newFollower;
    }

    protected synchronized void setObserver(Observer newObserver) {
        this.observer = newObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block42: {
            this.setName("QuorumPeer[myid=" + this.getId() + "]" + this.cnxnFactory.getLocalAddress());
            LOG.debug("Starting quorum peer");
            try {
                this.jmxQuorumBean = new QuorumBean(this);
                MBeanRegistry.getInstance().register(this.jmxQuorumBean, null);
                for (QuorumServer s : this.getView().values()) {
                    ZKMBeanInfo p;
                    if (this.getId() == s.id) {
                        this.jmxLocalPeerBean = new LocalPeerBean(this);
                        p = this.jmxLocalPeerBean;
                        try {
                            MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to register with JMX", e);
                            this.jmxLocalPeerBean = null;
                        }
                        continue;
                    }
                    p = new RemotePeerBean(s);
                    try {
                        MBeanRegistry.getInstance().register(p, this.jmxQuorumBean);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to register with JMX", e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", e);
                this.jmxQuorumBean = null;
            }
            try {
                while (this.running) {
                    switch (this.getPeerState()) {
                        case LOOKING: {
                            LOG.info("LOOKING");
                            if (Boolean.getBoolean("readonlymode.enabled")) {
                                Object var6_13;
                                LOG.info("Attempting to start ReadOnlyZooKeeperServer");
                                final ReadOnlyZooKeeperServer roZk = new ReadOnlyZooKeeperServer(this.logFactory, this, new ZooKeeperServer.BasicDataTreeBuilder(), this.zkDb);
                                Thread roZkMgr = new Thread(){

                                    public void run() {
                                        try {
                                            1.sleep(Math.max(2000, QuorumPeer.this.tickTime));
                                            if (ServerState.LOOKING.equals((Object)QuorumPeer.this.getPeerState())) {
                                                roZk.startup();
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            LOG.info("Interrupted while attempting to start ReadOnlyZooKeeperServer, not started");
                                        }
                                        catch (Exception e) {
                                            LOG.error("FAILED to start ReadOnlyZooKeeperServer", e);
                                        }
                                    }
                                };
                                try {
                                    try {
                                        roZkMgr.start();
                                        this.setBCVote(null);
                                        this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                                    }
                                    catch (Exception e) {
                                        LOG.warn("Unexpected exception", e);
                                        this.setPeerState(ServerState.LOOKING);
                                        var6_13 = null;
                                        roZkMgr.interrupt();
                                        roZk.shutdown();
                                        break;
                                    }
                                    var6_13 = null;
                                    roZkMgr.interrupt();
                                    roZk.shutdown();
                                    break;
                                }
                                catch (Throwable throwable) {
                                    var6_13 = null;
                                    roZkMgr.interrupt();
                                    roZk.shutdown();
                                    throw throwable;
                                }
                            }
                            try {
                                this.setBCVote(null);
                                this.setCurrentVote(this.makeLEStrategy().lookForLeader());
                            }
                            catch (Exception e) {
                                LOG.warn("Unexpected exception", e);
                                this.setPeerState(ServerState.LOOKING);
                            }
                            break;
                        }
                        case OBSERVING: {
                            Object var8_14;
                            try {
                                try {
                                    LOG.info("OBSERVING");
                                    this.setObserver(this.makeObserver(this.logFactory));
                                    this.observer.observeLeader();
                                }
                                catch (Exception e) {
                                    LOG.warn("Unexpected exception", e);
                                    var8_14 = null;
                                    this.observer.shutdown();
                                    this.setObserver(null);
                                    this.setPeerState(ServerState.LOOKING);
                                    break;
                                }
                                var8_14 = null;
                                this.observer.shutdown();
                                this.setObserver(null);
                                this.setPeerState(ServerState.LOOKING);
                                break;
                            }
                            catch (Throwable throwable) {
                                var8_14 = null;
                                this.observer.shutdown();
                                this.setObserver(null);
                                this.setPeerState(ServerState.LOOKING);
                                throw throwable;
                            }
                        }
                        case FOLLOWING: {
                            Object var10_15;
                            try {
                                try {
                                    LOG.info("FOLLOWING");
                                    this.setFollower(this.makeFollower(this.logFactory));
                                    this.follower.followLeader();
                                }
                                catch (Exception e) {
                                    LOG.warn("Unexpected exception", e);
                                    var10_15 = null;
                                    this.follower.shutdown();
                                    this.setFollower(null);
                                    this.setPeerState(ServerState.LOOKING);
                                    break;
                                }
                                var10_15 = null;
                                this.follower.shutdown();
                                this.setFollower(null);
                                this.setPeerState(ServerState.LOOKING);
                                break;
                            }
                            catch (Throwable throwable) {
                                var10_15 = null;
                                this.follower.shutdown();
                                this.setFollower(null);
                                this.setPeerState(ServerState.LOOKING);
                                throw throwable;
                            }
                        }
                        case LEADING: {
                            Object var12_16;
                            LOG.info("LEADING");
                            try {
                                try {
                                    this.setLeader(this.makeLeader(this.logFactory));
                                    this.leader.lead();
                                    this.setLeader(null);
                                }
                                catch (Exception e) {
                                    LOG.warn("Unexpected exception", e);
                                    var12_16 = null;
                                    if (this.leader != null) {
                                        this.leader.shutdown("Forcing shutdown");
                                        this.setLeader(null);
                                    }
                                    this.setPeerState(ServerState.LOOKING);
                                    break;
                                }
                                var12_16 = null;
                                if (this.leader != null) {
                                    this.leader.shutdown("Forcing shutdown");
                                    this.setLeader(null);
                                }
                                this.setPeerState(ServerState.LOOKING);
                                break;
                            }
                            catch (Throwable throwable) {
                                var12_16 = null;
                                if (this.leader != null) {
                                    this.leader.shutdown("Forcing shutdown");
                                    this.setLeader(null);
                                }
                                this.setPeerState(ServerState.LOOKING);
                                throw throwable;
                            }
                        }
                    }
                }
                Object var14_21 = null;
                LOG.warn("QuorumPeer main thread exited");
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                LOG.warn("QuorumPeer main thread exited");
                try {
                    MBeanRegistry.getInstance().unregisterAll();
                }
                catch (Exception e) {
                    LOG.warn("Failed to unregister with JMX", e);
                }
                this.jmxQuorumBean = null;
                this.jmxLocalPeerBean = null;
                throw throwable;
            }
            try {
                MBeanRegistry.getInstance().unregisterAll();
                break block42;
            }
            catch (Exception e) {
                LOG.warn("Failed to unregister with JMX", e);
            }
            {
            }
        }
        this.jmxQuorumBean = null;
        this.jmxLocalPeerBean = null;
    }

    public Map<Long, QuorumServer> getView() {
        return Collections.unmodifiableMap(this.quorumPeers);
    }

    public Map<Long, QuorumServer> getVotingView() {
        HashMap<Long, QuorumServer> ret = new HashMap<Long, QuorumServer>();
        Map<Long, QuorumServer> view = this.getView();
        for (QuorumServer server : view.values()) {
            if (server.type != LearnerType.PARTICIPANT) continue;
            ret.put(server.id, server);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getQuorumPeers() {
        ArrayList<String> l = new ArrayList<String>();
        QuorumPeer quorumPeer = this;
        synchronized (quorumPeer) {
            if (this.leader != null) {
                for (LearnerHandler fh : this.leader.getLearners()) {
                    if (fh.getSocket() == null) continue;
                    String s = fh.getSocket().getRemoteSocketAddress().toString();
                    if (this.leader.isLearnerSynced(fh)) {
                        s = s + "*";
                    }
                    l.add(s);
                }
            } else if (this.follower != null) {
                l.add(this.follower.sock.getRemoteSocketAddress().toString());
            }
        }
        return l.toArray(new String[0]);
    }

    @Override
    public String getServerState() {
        switch (this.getPeerState()) {
            case LOOKING: {
                return "leaderelection";
            }
            case LEADING: {
                return "leading";
            }
            case FOLLOWING: {
                return "following";
            }
            case OBSERVING: {
                return "observing";
            }
        }
        return "unknown";
    }

    public long getMyid() {
        return this.myid;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getInitLimit() {
        return this.initLimit;
    }

    public QuorumVerifier getQuorumVerifier() {
        return this.quorumConfig;
    }

    public boolean getSyncEnabled() {
        if (System.getProperty("zookeeper.observer.syncEnabled") != null) {
            LOG.info("zookeeper.observer.syncEnabled=" + Boolean.getBoolean("zookeeper.observer.syncEnabled"));
            return Boolean.getBoolean("zookeeper.observer.syncEnabled");
        }
        return this.syncEnabled;
    }

    public int getElectionType() {
        return this.electionType;
    }

    public boolean getQuorumListenOnAllIPs() {
        return this.quorumListenOnAllIPs;
    }

    public FileTxnSnapLog getTxnFactory() {
        return this.logFactory;
    }

    public boolean isRunning() {
        return this.running;
    }

    private long readLongFromFile(String name) throws IOException {
        long l;
        File file = new File(this.logFactory.getSnapDir(), name);
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = "";
        try {
            line = br.readLine();
            l = Long.parseLong(line);
            Object var8_7 = null;
        }
        catch (NumberFormatException e) {
            try {
                throw new IOException("Found " + line + " in " + file);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                br.close();
                throw throwable;
            }
        }
        br.close();
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeLongToFile(String name, long value) throws IOException {
        File file = new File(this.logFactory.getSnapDir(), name);
        AtomicFileOutputStream out = new AtomicFileOutputStream(file);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        boolean aborted = false;
        try {
            try {
                bw.write(Long.toString(value));
                bw.flush();
                out.flush();
            }
            catch (IOException e) {
                LOG.error("Failed to write new file " + file, e);
                aborted = true;
                out.abort();
                throw e;
            }
            Object var10_7 = null;
            if (aborted) return;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (aborted) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public long getCurrentEpoch() throws IOException {
        if (this.currentEpoch == -1L) {
            this.currentEpoch = this.readLongFromFile("currentEpoch");
        }
        return this.currentEpoch;
    }

    public long getAcceptedEpoch() throws IOException {
        if (this.acceptedEpoch == -1L) {
            this.acceptedEpoch = this.readLongFromFile("acceptedEpoch");
        }
        return this.acceptedEpoch;
    }

    public void setCurrentEpoch(long e) throws IOException {
        this.currentEpoch = e;
        this.writeLongToFile("currentEpoch", e);
    }

    public void setAcceptedEpoch(long e) throws IOException {
        this.acceptedEpoch = e;
        this.writeLongToFile("acceptedEpoch", e);
    }

    protected void updateElectionVote(long newEpoch) {
        Vote currentVote = this.getCurrentVote();
        this.setBCVote(currentVote);
        if (currentVote != null) {
            this.setCurrentVote(new Vote(currentVote.getId(), currentVote.getZxid(), currentVote.getElectionEpoch(), newEpoch, currentVote.getState()));
        }
    }

    @Deprecated
    class ResponderThread
    extends Thread {
        volatile boolean running;

        ResponderThread() {
            super("ResponderThread");
            this.running = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block20: {
                try {
                    try {
                        byte[] b = new byte[36];
                        ByteBuffer responseBuffer = ByteBuffer.wrap(b);
                        DatagramPacket packet = new DatagramPacket(b, b.length);
                        while (this.running) {
                            QuorumPeer.this.udpSocket.receive(packet);
                            if (packet.getLength() != 4) {
                                LOG.warn("Got more than just an xid! Len = " + packet.getLength());
                            } else {
                                responseBuffer.clear();
                                responseBuffer.getInt();
                                responseBuffer.putLong(QuorumPeer.this.myid);
                                Vote current = QuorumPeer.this.getCurrentVote();
                                switch (QuorumPeer.this.getPeerState()) {
                                    case LOOKING: {
                                        responseBuffer.putLong(current.getId());
                                        responseBuffer.putLong(current.getZxid());
                                        break;
                                    }
                                    case LEADING: {
                                        responseBuffer.putLong(QuorumPeer.this.myid);
                                        try {
                                            long proposed;
                                            Leader leader = QuorumPeer.this.leader;
                                            synchronized (leader) {
                                                proposed = QuorumPeer.this.leader.lastProposed;
                                            }
                                            responseBuffer.putLong(proposed);
                                        }
                                        catch (NullPointerException npe) {}
                                        break;
                                    }
                                    case FOLLOWING: {
                                        responseBuffer.putLong(current.getId());
                                        try {
                                            responseBuffer.putLong(QuorumPeer.this.follower.getZxid());
                                        }
                                        catch (NullPointerException npe) {}
                                        break;
                                    }
                                }
                                packet.setData(b);
                                QuorumPeer.this.udpSocket.send(packet);
                            }
                            packet.setLength(b.length);
                        }
                        Object var10_12 = null;
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Unexpected runtime exception in ResponderThread", e);
                        Object var10_13 = null;
                        LOG.warn("QuorumPeer responder thread exited");
                        break block20;
                    }
                    catch (IOException e) {
                        LOG.warn("Unexpected IO exception in ResponderThread", e);
                        Object var10_14 = null;
                        LOG.warn("QuorumPeer responder thread exited");
                    }
                    LOG.warn("QuorumPeer responder thread exited");
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    LOG.warn("QuorumPeer responder thread exited");
                    throw throwable;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LearnerType {
        PARTICIPANT,
        OBSERVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerState {
        LOOKING,
        FOLLOWING,
        LEADING,
        OBSERVING;

    }

    public static class QuorumServer {
        public InetSocketAddress addr;
        public InetSocketAddress electionAddr;
        public long id;
        public LearnerType type;
    }
}

