/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.HashMap;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.DataTreeBean;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.LearnerSessionTracker;
import org.apache.zookeeper.server.quorum.LocalPeerBean;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LearnerZooKeeperServer
extends QuorumZooKeeperServer {
    public LearnerZooKeeperServer(FileTxnSnapLog logFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb, QuorumPeer self) throws IOException {
        super(logFactory, tickTime, minSessionTimeout, maxSessionTimeout, treeBuilder, zkDb, self);
    }

    protected HashMap<Long, Integer> getTouchSnapshot() {
        if (this.sessionTracker != null) {
            return ((LearnerSessionTracker)this.sessionTracker).snapshot();
        }
        return new HashMap<Long, Integer>();
    }

    @Override
    public long getServerId() {
        return this.self.getId();
    }

    @Override
    public void createSessionTracker() {
        this.sessionTracker = new LearnerSessionTracker(this, this.getZKDatabase().getSessionWithTimeOuts(), this.self.getId());
    }

    @Override
    protected void startSessionTracker() {
    }

    @Override
    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(ZooKeeperServerBean serverBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = serverBean;
            MBeanRegistry.getInstance().register(serverBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    @Override
    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Learner peer) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
    }
}

