/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.server.util.KerberosUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosName {
    private final String serviceName;
    private final String hostName;
    private final String realm;
    private static final Pattern nameParser = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");
    private static Pattern parameterPattern = Pattern.compile("([^$]*)(\\$(\\d*))?");
    private static final Pattern ruleParser = Pattern.compile("\\s*((DEFAULT)|(RULE:\\[(\\d*):([^\\]]*)](\\(([^)]*)\\))?(s/([^/]*)/([^/]*)/(g)?)?))");
    private static final Pattern nonSimplePattern = Pattern.compile("[/@]");
    private static List<Rule> rules;
    private static String defaultRealm;

    public KerberosName(String name) {
        Matcher match = nameParser.matcher(name);
        if (!match.matches()) {
            if (name.contains("@")) {
                throw new IllegalArgumentException("Malformed Kerberos name: " + name);
            }
            this.serviceName = name;
            this.hostName = null;
            this.realm = null;
        } else {
            this.serviceName = match.group(1);
            this.hostName = match.group(3);
            this.realm = match.group(4);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.serviceName);
        if (this.hostName != null) {
            result.append('/');
            result.append(this.hostName);
        }
        if (this.realm != null) {
            result.append('@');
            result.append(this.realm);
        }
        return result.toString();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRealm() {
        return this.realm;
    }

    static List<Rule> parseRules(String rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        String remaining = rules.trim();
        while (remaining.length() > 0) {
            Matcher matcher = ruleParser.matcher(remaining);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + remaining);
            }
            if (matcher.group(2) != null) {
                result.add(new Rule());
            } else {
                result.add(new Rule(Integer.parseInt(matcher.group(4)), matcher.group(5), matcher.group(7), matcher.group(9), matcher.group(10), "g".equals(matcher.group(11))));
            }
            remaining = remaining.substring(matcher.end());
        }
        return result;
    }

    public static void setConfiguration() throws IOException {
        String ruleString = System.getProperty("zookeeper.security.auth_to_local", "DEFAULT");
        rules = KerberosName.parseRules(ruleString);
    }

    static {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception ke) {
            if (System.getProperty("zookeeper.requireKerberosConfig") != null && System.getProperty("zookeeper.requireKerberosConfig").equals("true")) {
                throw new IllegalArgumentException("Can't get Kerberos configuration", ke);
            }
            defaultRealm = "";
        }
        try {
            KerberosName.setConfiguration();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not configure Kerberos principal name mapping.");
        }
    }

    private static class Rule {
        private final boolean isDefault;
        private final int numOfComponents;
        private final String format;
        private final Pattern match;
        private final Pattern fromPattern;
        private final String toPattern;
        private final boolean repeat;

        Rule() {
            this.isDefault = true;
            this.numOfComponents = 0;
            this.format = null;
            this.match = null;
            this.fromPattern = null;
            this.toPattern = null;
            this.repeat = false;
        }

        Rule(int numOfComponents, String format, String match, String fromPattern, String toPattern, boolean repeat) {
            this.isDefault = false;
            this.numOfComponents = numOfComponents;
            this.format = format;
            this.match = match == null ? null : Pattern.compile(match);
            this.fromPattern = fromPattern == null ? null : Pattern.compile(fromPattern);
            this.toPattern = toPattern;
            this.repeat = repeat;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.isDefault) {
                buf.append("DEFAULT");
            } else {
                buf.append("RULE:[");
                buf.append(this.numOfComponents);
                buf.append(':');
                buf.append(this.format);
                buf.append(']');
                if (this.match != null) {
                    buf.append('(');
                    buf.append(this.match);
                    buf.append(')');
                }
                if (this.fromPattern != null) {
                    buf.append("s/");
                    buf.append(this.fromPattern);
                    buf.append('/');
                    buf.append(this.toPattern);
                    buf.append('/');
                    if (this.repeat) {
                        buf.append('g');
                    }
                }
            }
            return buf.toString();
        }
    }
}

