/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.DataTreeBean;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.UnimplementedRequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperServer
implements ServerStats.Provider,
SessionTracker.SessionExpirer {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperServer.class);
    protected ZooKeeperServerBean jmxServerBean;
    protected DataTreeBean jmxDataTreeBean;
    protected int tickTime = 3000;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    private ZKDatabase zkDb;
    protected long hzxid = 0L;
    public static final Exception ok;
    protected RequestProcessor firstProcessor;
    protected volatile boolean running;
    int requestsInProcess;
    final List<ChangeRecord> outstandingChanges = new ArrayList<ChangeRecord>();
    final HashMap<String, ChangeRecord> outstandingChangesForPath = new HashMap();
    private ServerCnxnFactory serverCnxnFactory;
    private final ServerStats serverStats = new ServerStats(this);

    public ZooKeeperServer() {
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, DataTreeBuilder treeBuilder, ZKDatabase zkDb) {
        this.txnLogFactory = txnLogFactory;
        this.zkDb = zkDb;
        this.tickTime = tickTime;
        this.minSessionTimeout = minSessionTimeout;
        this.maxSessionTimeout = maxSessionTimeout;
        LOG.info("Created server with tickTime " + tickTime + " minSessionTimeout " + this.getMinSessionTimeout() + " maxSessionTimeout " + this.getMaxSessionTimeout() + " datadir " + txnLogFactory.getDataDir() + " snapdir " + txnLogFactory.getSnapDir());
    }

    public ServerStats serverStats() {
        return this.serverStats;
    }

    public ZKDatabase getZKDatabase() {
        return this.zkDb;
    }

    public void loadData() throws IOException, InterruptedException {
        if (this.zkDb.isInitialized()) {
            this.setZxid(this.zkDb.getDataTreeLastProcessedZxid());
        } else {
            this.setZxid(this.zkDb.loadDataBase());
        }
        LinkedList<Long> deadSessions = new LinkedList<Long>();
        for (Long session : this.zkDb.getSessions()) {
            if (this.zkDb.getSessionWithTimeOuts().get(session) != null) continue;
            deadSessions.add(session);
        }
        this.zkDb.setDataTreeInit(true);
        for (long session : deadSessions) {
            this.killSession(session, this.zkDb.getDataTreeLastProcessedZxid());
        }
    }

    public void takeSnapshot() {
        try {
            this.txnLogFactory.save(this.zkDb.getDataTree(), this.zkDb.getSessionWithTimeOuts());
        }
        catch (IOException e) {
            LOG.error("Severe unrecoverable error, exiting", e);
            System.exit(10);
        }
    }

    public synchronized long getZxid() {
        return this.hzxid;
    }

    synchronized long getNextZxid() {
        return ++this.hzxid;
    }

    public synchronized void setZxid(long zxid) {
        this.hzxid = zxid;
    }

    long getTime() {
        return System.currentTimeMillis();
    }

    private void close(long sessionId) {
        this.submitRequest(null, sessionId, -11, 0, null, null);
    }

    protected void killSession(long sessionId, long zxid) {
        this.zkDb.killSession(sessionId, zxid);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(sessionId));
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    @Override
    public void expire(SessionTracker.Session session) {
        long sessionId = session.getSessionId();
        LOG.info("Expiring session 0x" + Long.toHexString(sessionId) + ", timeout of " + session.getTimeout() + "ms exceeded");
        this.close(sessionId);
    }

    void touch(ServerCnxn cnxn) throws MissingSessionException {
        int to;
        if (cnxn == null) {
            return;
        }
        long id = cnxn.getSessionId();
        if (!this.sessionTracker.touchSession(id, to = cnxn.getSessionTimeout())) {
            throw new MissingSessionException("No session with sessionid 0x" + Long.toHexString(id) + " exists, probably expired and removed");
        }
    }

    protected void registerJMX() {
        try {
            this.jmxServerBean = new ZooKeeperServerBean(this);
            MBeanRegistry.getInstance().register(this.jmxServerBean, null);
            try {
                this.jmxDataTreeBean = new DataTreeBean(this.zkDb.getDataTree());
                MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", e);
                this.jmxDataTreeBean = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        if (this.sessionTracker == null) {
            this.createSessionTracker();
        }
        this.startSessionTracker();
        this.setupRequestProcessors();
        this.registerJMX();
        ZooKeeperServer zooKeeperServer = this;
        synchronized (zooKeeperServer) {
            this.running = true;
            this.notifyAll();
        }
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this, finalProcessor);
        syncProcessor.start();
        this.firstProcessor = new PrepRequestProcessor(this, syncProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.zkDb.getSessionWithTimeOuts(), this.tickTime, 1L);
    }

    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        LOG.info("shutting down");
        this.running = false;
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.zkDb != null) {
            this.zkDb.clear();
        }
        this.unregisterJMX();
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
        this.jmxDataTreeBean = null;
    }

    public synchronized void incInProcess() {
        ++this.requestsInProcess;
    }

    public synchronized void decInProcess() {
        --this.requestsInProcess;
    }

    public int getInProcess() {
        return this.requestsInProcess;
    }

    byte[] generatePasswd(long id) {
        Random r = new Random(id ^ 0xB3415C00L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        return p;
    }

    public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        this.sessionTracker.setOwner(id, owner);
    }

    public void finishSessionInit(ServerCnxn cnxn, boolean valid) {
        try {
            if (valid) {
                this.serverCnxnFactory.registerConnection(cnxn);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
        }
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? cnxn.getSessionTimeout() : 0, valid ? cnxn.getSessionId() : 0L, valid ? this.generatePasswd(cnxn.getSessionId()) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            if (!cnxn.isOldClient) {
                bos.writeBool(this instanceof ReadOnlyZooKeeperServer, "readOnly");
            }
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            cnxn.sendBuffer(bb);
            if (!valid) {
                LOG.info("Invalid session 0x" + Long.toHexString(cnxn.getSessionId()) + " for client " + cnxn.getRemoteSocketAddress() + ", probably expired");
                cnxn.sendBuffer(ServerCnxnFactory.closeConn);
            } else {
                LOG.info("Established session 0x" + Long.toHexString(cnxn.getSessionId()) + " with negotiated timeout " + cnxn.getSessionTimeout() + " for client " + cnxn.getRemoteSocketAddress());
                cnxn.enableRecv();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while establishing session, closing", e);
            cnxn.close();
        }
    }

    public long getServerId() {
        return 0L;
    }

    private void submitRequest(ServerCnxn cnxn, long sessionId, int type, int xid, ByteBuffer bb, List<Id> authInfo) {
        Request si = new Request(cnxn, sessionId, xid, type, bb, authInfo);
        this.submitRequest(si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(Request si) {
        if (this.firstProcessor == null) {
            ZooKeeperServer zooKeeperServer = this;
            synchronized (zooKeeperServer) {
                try {
                    while (!this.running) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected interruption", e);
                }
                if (this.firstProcessor == null) {
                    throw new RuntimeException("Not started");
                }
            }
        }
        try {
            this.touch(si.cnxn);
            boolean validpacket = Request.isValid(si.type);
            if (validpacket) {
                this.firstProcessor.processRequest(si);
                if (si.cnxn != null) {
                    this.incInProcess();
                }
            } else {
                LOG.warn("Received packet at server of unknown type " + si.type);
                new UnimplementedRequestProcessor().processRequest(si);
            }
        }
        catch (MissingSessionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dropping request: " + e.getMessage());
            }
        }
        catch (RequestProcessor.RequestProcessorException e) {
            LOG.error("Unable to process request:" + e.getMessage(), e);
        }
    }

    public static int getSnapCount() {
        String sc = System.getProperty("zookeeper.snapCount");
        try {
            int snapCount = Integer.parseInt(sc);
            if (snapCount < 2) {
                LOG.warn("SnapCount should be 2 or more. Now, snapCount is reset to 2");
                snapCount = 2;
            }
            return snapCount;
        }
        catch (Exception e) {
            return 100000;
        }
    }

    public void setServerCnxnFactory(ServerCnxnFactory factory) {
        this.serverCnxnFactory = factory;
    }

    public ServerCnxnFactory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
    }

    public int getClientPort() {
        return this.serverCnxnFactory != null ? this.serverCnxnFactory.getLocalPort() : -1;
    }

    @Override
    public String getState() {
        return "standalone";
    }

    @Override
    public int getNumAliveConnections() {
        return this.serverCnxnFactory.getNumAliveConnections();
    }

    public DataTree.ProcessTxnResult processTxn(TxnHeader hdr, Record txn) {
        int opCode = hdr.getType();
        long sessionId = hdr.getClientId();
        DataTree.ProcessTxnResult rc = this.getZKDatabase().processTxn(hdr, txn);
        if (opCode == -10) {
            if (txn instanceof CreateSessionTxn) {
                CreateSessionTxn cst = (CreateSessionTxn)txn;
                this.sessionTracker.addSession(sessionId, cst.getTimeOut());
            } else {
                LOG.warn("*****>>>>> Got " + txn.getClass() + " " + txn.toString());
            }
        } else if (opCode == -11) {
            this.sessionTracker.removeSession(sessionId);
        }
        return rc;
    }

    static {
        Environment.logEnv("Server environment:", LOG);
        ok = new Exception("No prob");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChangeRecord {
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long zxid, String path, StatPersisted stat, int childCount, List<ACL> acl) {
            this.zxid = zxid;
            this.path = path;
            this.stat = stat;
            this.childCount = childCount;
            this.acl = acl;
        }

        ChangeRecord duplicate(long zxid) {
            StatPersisted stat = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, stat);
            }
            return new ChangeRecord(zxid, this.path, stat, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
        }
    }

    public static class MissingSessionException
    extends IOException {
        public MissingSessionException(String msg) {
            super(msg);
        }
    }

    public static class BasicDataTreeBuilder
    implements DataTreeBuilder {
    }

    public static interface DataTreeBuilder {
    }
}

