/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.ZooTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManager.class);
    private final HashMap<String, HashSet<Watcher>> watchTable = new HashMap();
    private final HashMap<Watcher, HashSet<String>> watch2Paths = new HashMap();

    public synchronized void addWatch(String path, Watcher watcher) {
        HashSet<Watcher> list = this.watchTable.get(path);
        if (list == null) {
            list = new HashSet(4);
            this.watchTable.put(path, list);
        }
        list.add(watcher);
        HashSet<String> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashSet();
            this.watch2Paths.put(watcher, paths);
        }
        paths.add(path);
    }

    public Set<Watcher> triggerWatch(String path, Watcher.Event.EventType type) {
        return this.triggerWatch(path, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Watcher> triggerWatch(String path, Watcher.Event.EventType type, Set<Watcher> supress) {
        HashSet<Watcher> watchers;
        WatchedEvent e = new WatchedEvent(type, Watcher.Event.KeeperState.SyncConnected, path);
        WatchManager watchManager = this;
        synchronized (watchManager) {
            watchers = this.watchTable.remove(path);
            if (watchers == null || watchers.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path);
                }
                return null;
            }
            for (Watcher w : watchers) {
                HashSet<String> paths = this.watch2Paths.get(w);
                if (paths == null) continue;
                paths.remove(path);
            }
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            w.process(e);
        }
        return watchers;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int total = 0;
        for (HashSet<String> paths : this.watch2Paths.values()) {
            total += paths.size();
        }
        sb.append("Total watches:").append(total);
        return sb.toString();
    }
}

