/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import javax.management.JMException;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.server.ConnectionBean;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;

public abstract class ServerCnxnFactory {
    Logger LOG;
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    protected ZooKeeperServer zkServer;
    private final Map<ServerCnxn, ConnectionBean> connectionBeans;
    protected final HashSet<ServerCnxn> cnxns;

    public abstract int getLocalPort();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumAliveConnections() {
        HashSet<ServerCnxn> hashSet = this.cnxns;
        synchronized (hashSet) {
            return this.cnxns.size();
        }
    }

    public abstract void closeSession(long var1);

    public abstract void start();

    public final void setZooKeeperServer(ZooKeeperServer zk) {
        this.zkServer = zk;
        if (zk != null) {
            zk.setServerCnxnFactory(this);
        }
    }

    public abstract void closeAll();

    public abstract InetSocketAddress getLocalAddress();

    public void registerConnection(ServerCnxn serverCnxn) {
        if (this.zkServer != null) {
            ConnectionBean jmxConnectionBean = new ConnectionBean(serverCnxn, this.zkServer);
            try {
                MBeanRegistry.getInstance().register(jmxConnectionBean, this.zkServer.jmxServerBean);
                this.connectionBeans.put(serverCnxn, jmxConnectionBean);
            }
            catch (JMException e) {
                this.LOG.warn("Could not register connection", e);
            }
        }
    }
}

