/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.proto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.jute.CsvOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.jute.Utils;

public class AuthPacket
implements Record {
    private int type;
    private String scheme;
    private byte[] auth;

    public AuthPacket() {
    }

    public AuthPacket(int type, String scheme, byte[] auth) {
        this.type = type;
        this.scheme = scheme;
        this.auth = auth;
    }

    public void serialize(OutputArchive a_, String tag) throws IOException {
        a_.startRecord(this, tag);
        a_.writeInt(this.type, "type");
        a_.writeString(this.scheme, "scheme");
        a_.writeBuffer(this.auth, "auth");
        a_.endRecord(this, tag);
    }

    public void deserialize(InputArchive a_, String tag) throws IOException {
        a_.startRecord(tag);
        this.type = a_.readInt("type");
        this.scheme = a_.readString("scheme");
        this.auth = a_.readBuffer("auth");
        a_.endRecord(tag);
    }

    public String toString() {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            CsvOutputArchive a_ = new CsvOutputArchive(s);
            a_.startRecord(this, "");
            a_.writeInt(this.type, "type");
            a_.writeString(this.scheme, "scheme");
            a_.writeBuffer(this.auth, "auth");
            a_.endRecord(this, "");
            return new String(s.toByteArray(), "UTF-8");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return "ERROR";
        }
    }

    public boolean equals(Object peer_) {
        if (!(peer_ instanceof AuthPacket)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        AuthPacket peer = (AuthPacket)peer_;
        boolean ret = false;
        boolean bl = ret = this.type == peer.type;
        if (!ret) {
            return ret;
        }
        ret = this.scheme.equals(peer.scheme);
        if (!ret) {
            return ret;
        }
        ret = Utils.bufEquals(this.auth, peer.auth);
        if (!ret) {
            return ret;
        }
        return ret;
    }

    public int hashCode() {
        int result = 17;
        int ret = this.type;
        result = 37 * result + ret;
        ret = this.scheme.hashCode();
        result = 37 * result + ret;
        ret = Arrays.toString(this.auth).hashCode();
        result = 37 * result + ret;
        return result;
    }
}

