/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.zookeeper.common.PathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectStringParser {
    private final String chrootPath;
    private final ArrayList<InetSocketAddress> serverAddresses = new ArrayList();

    public ConnectStringParser(String connectString) {
        String[] hostsList;
        int off = connectString.indexOf(47);
        if (off >= 0) {
            String chrootPath = connectString.substring(off);
            if (chrootPath.length() == 1) {
                this.chrootPath = null;
            } else {
                PathUtils.validatePath(chrootPath);
                this.chrootPath = chrootPath;
            }
            connectString = connectString.substring(0, off);
        } else {
            this.chrootPath = null;
        }
        for (String host : hostsList = connectString.split(",")) {
            int port = 2181;
            int pidx = host.lastIndexOf(58);
            if (pidx >= 0) {
                if (pidx < host.length() - 1) {
                    port = Integer.parseInt(host.substring(pidx + 1));
                }
                host = host.substring(0, pidx);
            }
            this.serverAddresses.add(InetSocketAddress.createUnresolved(host, port));
        }
    }

    public String getChrootPath() {
        return this.chrootPath;
    }

    public ArrayList<InetSocketAddress> getServerAddresses() {
        return this.serverAddresses;
    }
}

