/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

public class Utils {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean bufEquals(byte[] onearray, byte[] twoarray) {
        boolean ret;
        if (onearray == twoarray) {
            return true;
        }
        boolean bl = ret = onearray.length == twoarray.length;
        if (!ret) {
            return ret;
        }
        for (int idx = 0; idx < onearray.length; ++idx) {
            if (onearray[idx] == twoarray[idx]) continue;
            return false;
        }
        return true;
    }

    static String toCSVString(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        sb.append('\'');
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("%00");
                    continue block8;
                }
                case '\n': {
                    sb.append("%0A");
                    continue block8;
                }
                case '\r': {
                    sb.append("%0D");
                    continue block8;
                }
                case ',': {
                    sb.append("%2C");
                    continue block8;
                }
                case '}': {
                    sb.append("%7D");
                    continue block8;
                }
                case '%': {
                    sb.append("%25");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String toCSVBuffer(byte[] barr) {
        if (barr == null || barr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(barr.length + 1);
        sb.append('#');
        for (int idx = 0; idx < barr.length; ++idx) {
            sb.append(Integer.toHexString(barr[idx]));
        }
        return sb.toString();
    }
}

