/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import net.hydromatic.avatica.DriverVersion;
import net.hydromatic.avatica.Handler;
import net.hydromatic.avatica.HandlerImpl;
import net.hydromatic.avatica.UnregisteredDriver;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:drill:";

    public static boolean load() {
        return true;
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                return "org.apache.drill.jdbc.DrillJdbc3Factory";
            }
            case JDBC_40: {
                return "org.apache.drill.jdbc.DrillJdbc40Factory";
            }
        }
        return "org.apache.drill.jdbc.DrillJdbc41Factory";
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "apache-drill-jdbc.properties", "Drill JDBC Driver", "unknown version", "Optiq", "unknown version");
    }

    @Override
    protected Handler createHandler() {
        return new HandlerImpl();
    }

    static {
        new Driver().register();
    }
}

