/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.user;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.Foreman;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWorker {
    static final Logger logger = LoggerFactory.getLogger(UserWorker.class);
    private final WorkManager.WorkerBee bee;

    public UserWorker(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    public UserBitShared.QueryId submitWork(UserServer.UserClientConnection connection, UserProtos.RunQuery query) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        long time = (int)(System.currentTimeMillis() / 1000L);
        long p1 = (Integer.MAX_VALUE - time << 32) + (long)r.nextInt();
        long p2 = r.nextLong();
        UserBitShared.QueryId id = UserBitShared.QueryId.newBuilder().setPart1(p1).setPart2(p2).build();
        Foreman foreman = new Foreman(this.bee, this.bee.getContext(), connection, id, query);
        this.bee.addNewForeman(foreman);
        return id;
    }

    public GeneralRPCProtos.Ack cancelQuery(UserBitShared.QueryId query) {
        Foreman foreman = this.bee.getForemanForQueryId(query);
        if (foreman != null) {
            foreman.cancel();
        }
        return Acks.OK;
    }

    public OptionManager getSystemOptions() {
        return this.bee.getContext().getOptionManager();
    }
}

