/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootFragmentManager
implements FragmentManager {
    static final Logger logger = LoggerFactory.getLogger(RootFragmentManager.class);
    private final IncomingBuffers buffers;
    private final FragmentExecutor runner;
    private final ExecProtos.FragmentHandle handle;
    private volatile boolean cancel = false;
    private List<RemoteConnection> connections = new CopyOnWriteArrayList<RemoteConnection>();

    public RootFragmentManager(ExecProtos.FragmentHandle handle, IncomingBuffers buffers, FragmentExecutor runner) {
        this.handle = handle;
        this.buffers = buffers;
        this.runner = runner;
    }

    @Override
    public boolean handle(RawFragmentBatch batch) throws FragmentSetupException, IOException {
        return this.buffers.batchArrived(batch);
    }

    @Override
    public FragmentExecutor getRunnable() {
        return this.runner;
    }

    @Override
    public ExecProtos.FragmentHandle getHandle() {
        return this.handle;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public boolean isWaiting() {
        return !this.buffers.isDone() && !this.cancel;
    }

    @Override
    public FragmentContext getFragmentContext() {
        return this.runner.getContext();
    }
}

