/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.work.ErrorHelper;
import org.apache.drill.exec.work.fragment.StatusReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatusReporter
implements StatusReporter {
    static final Logger logger = LoggerFactory.getLogger(AbstractStatusReporter.class);
    private FragmentContext context;
    private volatile long startNanos;

    public AbstractStatusReporter(FragmentContext context) {
        this.context = context;
    }

    private BitControl.FragmentStatus.Builder getBuilder(UserBitShared.FragmentState state) {
        return this.getBuilder(state, null, null);
    }

    private BitControl.FragmentStatus.Builder getBuilder(UserBitShared.FragmentState state, String message, Throwable t) {
        BitControl.FragmentStatus.Builder status = BitControl.FragmentStatus.newBuilder();
        UserBitShared.MinorFragmentProfile.Builder b = UserBitShared.MinorFragmentProfile.newBuilder();
        this.context.getStats().addMetricsToStatus(b);
        b.setState(state);
        if (t != null) {
            boolean verbose = this.context.getOptions().getOption((String)"exec.errors.verbose").bool_val;
            b.setError(ErrorHelper.logAndConvertMessageError(this.context.getIdentity(), message, t, logger, verbose));
        }
        status.setHandle(this.context.getHandle());
        b.setMemoryUsed(this.context.getAllocator().getAllocatedMemory());
        b.setMinorFragmentId(this.context.getHandle().getMinorFragmentId());
        status.setProfile(b);
        return status;
    }

    @Override
    public void stateChanged(ExecProtos.FragmentHandle handle, UserBitShared.FragmentState newState) {
        BitControl.FragmentStatus.Builder status = this.getBuilder(newState);
        switch (newState) {
            case AWAITING_ALLOCATION: {
                this.awaitingAllocation(handle, status);
                break;
            }
            case CANCELLED: {
                this.cancelled(handle, status);
                break;
            }
            case FAILED: {
                break;
            }
            case FINISHED: {
                this.finished(handle, status);
                break;
            }
            case RUNNING: {
                this.startNanos = System.nanoTime();
                this.running(handle, status);
                break;
            }
            case SENDING: {
                break;
            }
        }
    }

    protected void awaitingAllocation(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus.Builder statusBuilder) {
        this.statusChange(handle, statusBuilder.build());
    }

    protected void running(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus.Builder statusBuilder) {
        this.statusChange(handle, statusBuilder.build());
    }

    protected void cancelled(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus.Builder statusBuilder) {
        this.statusChange(handle, statusBuilder.build());
    }

    protected void finished(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus.Builder statusBuilder) {
        this.statusChange(handle, statusBuilder.build());
    }

    protected abstract void statusChange(ExecProtos.FragmentHandle var1, BitControl.FragmentStatus var2);

    @Override
    public final void fail(ExecProtos.FragmentHandle handle, String message, Throwable excep) {
        BitControl.FragmentStatus.Builder status = this.getBuilder(UserBitShared.FragmentState.FAILED, message, excep);
        this.fail(handle, status);
    }

    protected void fail(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus.Builder statusBuilder) {
        this.statusChange(handle, statusBuilder.build());
    }
}

