/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.RemoteRpcException;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.work.foreman.DrillbitStatusListener;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.ForemanException;
import org.apache.drill.exec.work.foreman.FragmentData;
import org.apache.drill.exec.work.foreman.FragmentStatusListener;
import org.apache.drill.exec.work.foreman.QueryStatus;
import org.apache.drill.exec.work.fragment.AbstractStatusReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManager
implements DrillbitStatusListener,
FragmentStatusListener {
    static final Logger logger = LoggerFactory.getLogger(QueryManager.class);
    private final Set<CoordinationProtos.DrillbitEndpoint> includedBits;
    private final QueryStatus status;
    private final Foreman.StateListener stateListener;
    private final AtomicInteger remainingFragmentCount;
    private final UserBitShared.QueryId queryId;

    public QueryManager(UserBitShared.QueryId id, UserProtos.RunQuery query, PStoreProvider pStoreProvider, Foreman.StateListener stateListener, Foreman foreman) {
        this.stateListener = stateListener;
        this.queryId = id;
        this.remainingFragmentCount = new AtomicInteger(0);
        this.status = new QueryStatus(query, id, pStoreProvider, foreman);
        this.includedBits = Sets.newHashSet();
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    @Override
    public void drillbitUnregistered(Set<CoordinationProtos.DrillbitEndpoint> unregisteredDrillbits) {
        for (CoordinationProtos.DrillbitEndpoint ep : unregisteredDrillbits) {
            if (!this.includedBits.contains(ep)) continue;
            logger.warn("Drillbit {} no longer registered in cluster.  Canceling query {}", (Object)(ep.getAddress() + ep.getControlPort()), (Object)QueryIdHelper.getQueryId(this.queryId));
            this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new ForemanException("One more more nodes lost connectivity during query.  Identified node was " + ep.getAddress()));
        }
    }

    @Override
    public void statusUpdate(BitControl.FragmentStatus status) {
        logger.debug("New fragment status was provided to Foreman of {}", (Object)status);
        switch (status.getProfile().getState()) {
            case AWAITING_ALLOCATION: {
                this.updateFragmentStatus(status);
                break;
            }
            case CANCELLED: {
                break;
            }
            case FAILED: {
                this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new RemoteRpcException(status.getProfile().getError()));
                break;
            }
            case FINISHED: {
                this.finished(status);
                break;
            }
            case RUNNING: {
                this.updateFragmentStatus(status);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Received status of %s", status));
            }
        }
    }

    private void updateFragmentStatus(BitControl.FragmentStatus status) {
        this.status.updateFragmentStatus(status);
    }

    private void finished(BitControl.FragmentStatus status) {
        this.status.incrementFinishedFragments();
        int remaining = this.remainingFragmentCount.decrementAndGet();
        this.updateFragmentStatus(status);
        if (remaining == 0) {
            this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.COMPLETED, null);
        }
    }

    public void setup(ExecProtos.FragmentHandle rootFragmentHandle, CoordinationProtos.DrillbitEndpoint localIdentity, int countOfNonRootFragments) {
        this.remainingFragmentCount.set(countOfNonRootFragments + 1);
        this.status.add(new FragmentData(rootFragmentHandle, localIdentity, true));
        this.status.setTotalFragments(countOfNonRootFragments + 1);
        List<FragmentData> fragments = this.status.getFragmentData();
        for (FragmentData fragment : fragments) {
            this.includedBits.add(fragment.getEndpoint());
        }
    }

    public void addFragmentStatusTracker(BitControl.PlanFragment fragment, boolean isRoot) {
        this.addFragmentStatusTracker(fragment.getHandle(), fragment.getAssignment(), isRoot);
    }

    public void addFragmentStatusTracker(ExecProtos.FragmentHandle handle, CoordinationProtos.DrillbitEndpoint node, boolean isRoot) {
        this.status.add(new FragmentData(handle, node, isRoot));
    }

    public RootStatusReporter getRootStatusHandler(FragmentContext context, BitControl.PlanFragment fragment) {
        return new RootStatusReporter(context, fragment);
    }

    class RootStatusReporter
    extends AbstractStatusReporter {
        private RootStatusReporter(FragmentContext context, BitControl.PlanFragment fragment) {
            super(context);
        }

        @Override
        protected void statusChange(ExecProtos.FragmentHandle handle, BitControl.FragmentStatus status) {
            QueryManager.this.statusUpdate(status);
        }
    }
}

