/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import com.google.common.collect.ArrayListMultimap;
import io.netty.buffer.ByteBuf;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.coord.DistributedSemaphore;
import org.apache.drill.exec.exception.OptimizerException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.opt.BasicOptimizer;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.ExternalSort;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import org.apache.drill.exec.planner.fragment.StatsCollector;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.DrillSqlWorker;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.EndpointListener;
import org.apache.drill.exec.work.ErrorHelper;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.apache.drill.exec.work.foreman.ForemanException;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.FragmentData;
import org.apache.drill.exec.work.foreman.QueryManager;
import org.apache.drill.exec.work.foreman.QueryStatus;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.RootFragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Foreman
implements Closeable,
Comparable<Object>,
Runnable {
    static final Logger logger = LoggerFactory.getLogger(Foreman.class);
    private UserBitShared.QueryId queryId;
    private UserProtos.RunQuery queryRequest;
    private QueryContext context;
    private QueryManager queryManager;
    private WorkManager.WorkerBee bee;
    private UserServer.UserClientConnection initiatingClient;
    private volatile UserBitShared.QueryResult.QueryState state;
    private final DistributedSemaphore smallSemaphore;
    private final DistributedSemaphore largeSemaphore;
    private final long queueThreshold;
    private final long queueTimeout;
    private volatile DistributedSemaphore.DistributedLease lease;
    private final boolean queuingEnabled;
    private FragmentExecutor rootRunner;
    private final CountDownLatch acceptExternalEvents = new CountDownLatch(1);
    private final StateListener stateListener = new StateListener();
    private final ResponseSendListener responseListener = new ResponseSendListener();

    public Foreman(WorkManager.WorkerBee bee, DrillbitContext dContext, UserServer.UserClientConnection connection, UserBitShared.QueryId queryId, UserProtos.RunQuery queryRequest) {
        this.queryId = queryId;
        this.queryRequest = queryRequest;
        this.context = new QueryContext(connection.getSession(), queryId, dContext);
        this.queuingEnabled = this.context.getOptions().getOption((String)"exec.queue.enable").bool_val;
        if (this.queuingEnabled) {
            int smallQueue = this.context.getOptions().getOption((String)"exec.queue.small").num_val.intValue();
            int largeQueue = this.context.getOptions().getOption((String)"exec.queue.large").num_val.intValue();
            this.largeSemaphore = dContext.getClusterCoordinator().getSemaphore("query.large", largeQueue);
            this.smallSemaphore = dContext.getClusterCoordinator().getSemaphore("query.small", smallQueue);
            this.queueThreshold = this.context.getOptions().getOption((String)"exec.queue.threshold").num_val;
            this.queueTimeout = this.context.getOptions().getOption((String)"exec.queue.timeout_millis").num_val;
        } else {
            this.largeSemaphore = null;
            this.smallSemaphore = null;
            this.queueThreshold = 0L;
            this.queueTimeout = 0L;
        }
        this.initiatingClient = connection;
        this.queryManager = new QueryManager(queryId, queryRequest, bee.getContext().getPersistentStoreProvider(), this.stateListener, this);
        this.bee = bee;
        this.recordNewState(UserBitShared.QueryResult.QueryState.PENDING);
    }

    public QueryContext getContext() {
        return this.context;
    }

    public void cancel() {
        this.stateListener.moveToState(UserBitShared.QueryResult.QueryState.CANCELED, null);
    }

    private void cleanup(UserBitShared.QueryResult result) {
        this.bee.retireForeman(this);
        this.context.getWorkBus().removeFragmentStatusListener(this.queryId);
        this.context.getClusterCoordinator().removeDrillbitStatusListener(this.queryManager);
        if (result != null) {
            this.initiatingClient.sendResult(this.responseListener, new QueryWritableBatch(result, new ByteBuf[0]), true);
        }
        this.releaseLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        String originalThread = Thread.currentThread().getName();
        Thread.currentThread().setName(QueryIdHelper.getQueryId(this.queryId) + ":foreman");
        this.getStatus().markStart();
        try {
            switch (this.queryRequest.getType()) {
                case LOGICAL: {
                    this.parseAndRunLogicalPlan(this.queryRequest.getPlan());
                    return;
                }
                case PHYSICAL: {
                    this.parseAndRunPhysicalPlan(this.queryRequest.getPlan());
                    return;
                }
                case SQL: {
                    this.runSQL(this.queryRequest.getPlan());
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (ForemanException e) {
            this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, e);
            return;
        }
        catch (AssertionError | Exception ex) {
            this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new ForemanException("Unexpected exception during fragment initialization: " + ((Throwable)ex).getMessage(), (Throwable)ex));
            return;
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of memory, exiting.");
            e.printStackTrace();
            System.out.flush();
            System.exit(-1);
            return;
        }
        finally {
            Thread.currentThread().setName(originalThread);
        }
    }

    private void releaseLease() {
        if (this.lease != null) {
            try {
                this.lease.close();
            }
            catch (Exception e) {
                logger.warn("Failure while releasing lease.", e);
            }
        }
    }

    private void parseAndRunLogicalPlan(String json) throws ExecutionSetupException {
        LogicalPlan logicalPlan;
        try {
            logicalPlan = this.context.getPlanReader().readLogicalPlan(json);
        }
        catch (IOException e) {
            throw new ForemanException("Failure parsing logical plan.", e);
        }
        if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.LOGICAL) {
            throw new ForemanException("Failure running plan.  You requested a result mode of LOGICAL and submitted a logical plan.  In this case you're output mode must be PHYSICAL or EXEC.");
        }
        this.log(logicalPlan);
        PhysicalPlan physicalPlan = this.convert(logicalPlan);
        if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.PHYSICAL) {
            this.returnPhysical(physicalPlan);
            return;
        }
        this.log(physicalPlan);
        this.runPhysicalPlan(physicalPlan);
    }

    private void log(LogicalPlan plan) {
        if (logger.isDebugEnabled()) {
            logger.debug("Logical {}", (Object)plan.unparse(this.context.getConfig()));
        }
    }

    private void log(PhysicalPlan plan) {
        if (logger.isDebugEnabled()) {
            try {
                String planText = this.context.getConfig().getMapper().writeValueAsString(plan);
                logger.debug("Physical {}", (Object)planText);
            }
            catch (IOException e) {
                logger.warn("Error while attempting to log physical plan.", e);
            }
        }
    }

    private void returnPhysical(PhysicalPlan plan) throws ExecutionSetupException {
        String jsonPlan = plan.unparse(this.context.getConfig().getMapper().writer());
        this.runPhysicalPlan(DirectPlan.createDirectPlan(this.context, new PhysicalFromLogicalExplain(jsonPlan)));
    }

    private void parseAndRunPhysicalPlan(String json) throws ExecutionSetupException {
        try {
            PhysicalPlan plan = this.context.getPlanReader().readPhysicalPlan(json);
            this.runPhysicalPlan(plan);
        }
        catch (IOException e) {
            throw new ForemanSetupException("Failure while parsing physical plan.", e);
        }
    }

    private void runPhysicalPlan(PhysicalPlan plan) throws ExecutionSetupException {
        this.validatePlan(plan);
        this.setupSortMemoryAllocations(plan);
        this.acquireQuerySemaphore(plan);
        QueryWorkUnit work = this.getQueryWorkUnit(plan);
        this.context.getWorkBus().setFragmentStatusListener(work.getRootFragment().getHandle().getQueryId(), this.queryManager);
        this.context.getClusterCoordinator().addDrillbitStatusListener(this.queryManager);
        logger.debug("Submitting fragments to run.");
        BitControl.PlanFragment rootPlanFragment = work.getRootFragment();
        assert (this.queryId == rootPlanFragment.getHandle().getQueryId());
        this.queryManager.setup(rootPlanFragment.getHandle(), this.context.getCurrentEndpoint(), work.getFragments().size());
        this.setupRootFragment(rootPlanFragment, this.initiatingClient, work.getRootOperator());
        this.setupNonRootFragments(work.getFragments());
        this.bee.getContext().getAllocator().resetFragmentLimits();
        this.moveToState(UserBitShared.QueryResult.QueryState.RUNNING, null);
        logger.debug("Fragments running.");
    }

    private void validatePlan(PhysicalPlan plan) throws ForemanSetupException {
        if (plan.getProperties().resultMode != PlanProperties.Generator.ResultMode.EXEC) {
            throw new ForemanSetupException(String.format("Failure running plan.  You requested a result mode of %s and a physical plan can only be output as EXEC", new Object[]{plan.getProperties().resultMode}));
        }
    }

    private void setupSortMemoryAllocations(PhysicalPlan plan) {
        int sortCount = 0;
        for (PhysicalOperator op : plan.getSortedOperators()) {
            if (!(op instanceof ExternalSort)) continue;
            ++sortCount;
        }
        if (sortCount > 0) {
            long maxWidthPerNode = this.context.getOptions().getOption((String)"planner.width.max_per_node").num_val;
            long maxAllocPerNode = Math.min(DrillConfig.getMaxDirectMemory(), this.context.getConfig().getLong("drill.exec.memory.top.max"));
            maxAllocPerNode = Math.min(maxAllocPerNode, this.context.getOptions().getOption((String)"planner.memory.max_query_memory_per_node").num_val);
            long maxSortAlloc = maxAllocPerNode / ((long)sortCount * maxWidthPerNode);
            logger.debug("Max sort alloc: {}", (Object)maxSortAlloc);
            for (PhysicalOperator op : plan.getSortedOperators()) {
                if (!(op instanceof ExternalSort)) continue;
                ((ExternalSort)op).setMaxAllocation(maxSortAlloc);
            }
        }
    }

    private void acquireQuerySemaphore(PhysicalPlan plan) throws ForemanSetupException {
        double size = 0.0;
        for (PhysicalOperator ops : plan.getSortedOperators()) {
            size += ops.getCost();
        }
        if (this.queuingEnabled) {
            try {
                this.lease = size > (double)this.queueThreshold ? this.largeSemaphore.acquire(this.queueTimeout, TimeUnit.MILLISECONDS) : this.smallSemaphore.acquire(this.queueTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new ForemanSetupException("Unable to acquire slot for query.", e);
            }
        }
    }

    private QueryWorkUnit getQueryWorkUnit(PhysicalPlan plan) throws ExecutionSetupException {
        PhysicalOperator rootOperator = plan.getSortedOperators(false).iterator().next();
        MakeFragmentsVisitor makeFragmentsVisitor = new MakeFragmentsVisitor();
        Fragment rootFragment = rootOperator.accept(makeFragmentsVisitor, null);
        PlanningSet planningSet = StatsCollector.collectStats(rootFragment);
        SimpleParallelizer parallelizer = new SimpleParallelizer(this.context);
        return parallelizer.getFragments(this.context.getOptions().getOptionList(), this.context.getCurrentEndpoint(), this.queryId, this.context.getActiveEndpoints(), this.context.getPlanReader(), rootFragment, planningSet, this.initiatingClient.getSession());
    }

    private synchronized boolean moveToState(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        logger.debug("State change requested.  {} --> {}", (Object)this.state, (Object)newState);
        switch (this.state) {
            case PENDING: {
                this.acceptExternalEvents.countDown();
                if (newState == UserBitShared.QueryResult.QueryState.RUNNING) {
                    this.recordNewState(UserBitShared.QueryResult.QueryState.RUNNING);
                    return true;
                }
            }
            case RUNNING: {
                switch (newState) {
                    case CANCELED: {
                        assert (exception == null);
                        this.recordNewState(UserBitShared.QueryResult.QueryState.CANCELED);
                        this.cancelExecutingFragments();
                        UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().setQueryId(this.queryId).setQueryState(UserBitShared.QueryResult.QueryState.CANCELED).setIsLastChunk(true).build();
                        this.cleanup(result);
                        return true;
                    }
                    case COMPLETED: {
                        assert (exception == null);
                        this.recordNewState(UserBitShared.QueryResult.QueryState.COMPLETED);
                        UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().setQueryState(UserBitShared.QueryResult.QueryState.COMPLETED).setQueryId(this.queryId).build();
                        this.cleanup(result);
                        return true;
                    }
                    case FAILED: {
                        assert (exception != null);
                        this.recordNewState(UserBitShared.QueryResult.QueryState.FAILED);
                        this.cancelExecutingFragments();
                        UserBitShared.DrillPBError error = ErrorHelper.logAndConvertError(this.context.getCurrentEndpoint(), "Query failed: " + exception.getMessage(), exception, logger);
                        UserBitShared.QueryResult result = UserBitShared.QueryResult.newBuilder().addError(error).setIsLastChunk(true).setQueryState(UserBitShared.QueryResult.QueryState.FAILED).setQueryId(this.queryId).build();
                        this.cleanup(result);
                        return true;
                    }
                }
                break;
            }
            case CANCELED: 
            case COMPLETED: 
            case FAILED: {
                logger.info("Dropping request to move to {} state as query is already at {} state (which is terminal).", newState, this.state, exception);
                return false;
            }
        }
        throw new IllegalStateException(String.format("Failure trying to change states: %s --> %s", this.state.name(), newState.name()));
    }

    private void cancelExecutingFragments() {
        List<FragmentData> fragments = this.getStatus().getFragmentData();
        Collections.sort(fragments, new Comparator<FragmentData>(){

            @Override
            public int compare(FragmentData o1, FragmentData o2) {
                return o2.getHandle().getMajorFragmentId() - o1.getHandle().getMajorFragmentId();
            }
        });
        for (FragmentData data : fragments) {
            ExecProtos.FragmentHandle handle = data.getStatus().getHandle();
            switch (data.getStatus().getProfile().getState()) {
                case SENDING: 
                case AWAITING_ALLOCATION: 
                case RUNNING: {
                    if (data.isLocal()) {
                        this.rootRunner.cancel();
                        break;
                    }
                    this.bee.getContext().getController().getTunnel(data.getEndpoint()).cancelFragment(new CancelListener(data.getEndpoint(), handle), handle);
                    break;
                }
            }
        }
    }

    private QueryStatus getStatus() {
        return this.queryManager.getStatus();
    }

    private void recordNewState(UserBitShared.QueryResult.QueryState newState) {
        this.state = newState;
        this.getStatus().updateQueryStateInStore(newState);
    }

    private void runSQL(String sql) throws ExecutionSetupException {
        DrillSqlWorker sqlWorker = new DrillSqlWorker(this.context);
        Pointer<String> textPlan = new Pointer<String>();
        PhysicalPlan plan = sqlWorker.getPlan(sql, textPlan);
        this.getStatus().setPlanText((String)textPlan.value);
        this.runPhysicalPlan(plan);
    }

    private PhysicalPlan convert(LogicalPlan plan) throws OptimizerException {
        if (logger.isDebugEnabled()) {
            logger.debug("Converting logical plan {}.", (Object)plan.toJsonStringSafe(this.context.getConfig()));
        }
        return new BasicOptimizer(DrillConfig.create(), this.context, this.initiatingClient).optimize(new BasicOptimizer.BasicOptimizationContext(this.context), plan);
    }

    public UserBitShared.QueryId getQueryId() {
        return this.queryId;
    }

    @Override
    public void close() throws IOException {
    }

    public QueryStatus getQueryStatus() {
        return this.queryManager.getStatus();
    }

    private void setupRootFragment(BitControl.PlanFragment rootFragment, UserServer.UserClientConnection rootClient, FragmentRoot rootOperator) throws ExecutionSetupException {
        FragmentContext rootContext = new FragmentContext(this.bee.getContext(), rootFragment, rootClient, this.bee.getContext().getFunctionImplementationRegistry());
        IncomingBuffers buffers = new IncomingBuffers(rootOperator, rootContext);
        rootContext.setBuffers(buffers);
        this.queryManager.addFragmentStatusTracker(rootFragment, true);
        this.rootRunner = new FragmentExecutor(rootContext, this.bee, rootOperator, this.queryManager.getRootStatusHandler(rootContext, rootFragment));
        RootFragmentManager fragmentManager = new RootFragmentManager(rootFragment.getHandle(), buffers, this.rootRunner);
        if (buffers.isDone()) {
            this.bee.addFragmentRunner(fragmentManager.getRunnable());
        } else {
            this.bee.getContext().getWorkBus().setFragmentManager(fragmentManager);
        }
    }

    private void setupNonRootFragments(Collection<BitControl.PlanFragment> fragments) throws ForemanException {
        ArrayListMultimap leafFragmentMap = ArrayListMultimap.create();
        ArrayListMultimap intFragmentMap = ArrayListMultimap.create();
        for (BitControl.PlanFragment f : fragments) {
            this.queryManager.addFragmentStatusTracker(f, false);
            if (f.getLeafFragment()) {
                leafFragmentMap.put(f.getAssignment(), f);
                continue;
            }
            intFragmentMap.put(f.getAssignment(), f);
        }
        CountDownLatch latch = new CountDownLatch(intFragmentMap.keySet().size());
        for (CoordinationProtos.DrillbitEndpoint ep : intFragmentMap.keySet()) {
            this.sendRemoteFragments(ep, intFragmentMap.get(ep), latch);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new ForemanException("Interrupted while waiting to complete send of remote fragments.", e);
        }
        for (CoordinationProtos.DrillbitEndpoint ep : leafFragmentMap.keySet()) {
            this.sendRemoteFragments(ep, leafFragmentMap.get(ep), null);
        }
    }

    private void sendRemoteFragments(CoordinationProtos.DrillbitEndpoint assignment, Collection<BitControl.PlanFragment> fragments, CountDownLatch latch) {
        Controller controller = this.bee.getContext().getController();
        BitControl.InitializeFragments.Builder fb = BitControl.InitializeFragments.newBuilder();
        for (BitControl.PlanFragment f : fragments) {
            fb.addFragment(f);
        }
        BitControl.InitializeFragments initFrags = fb.build();
        logger.debug("Sending remote fragments to node {} with data {}", (Object)assignment, (Object)initFrags);
        FragmentSubmitListener listener = new FragmentSubmitListener(assignment, initFrags, latch);
        controller.getTunnel(assignment).sendFragments(listener, initFrags);
    }

    public UserBitShared.QueryResult.QueryState getState() {
        return this.state;
    }

    @Override
    public int compareTo(Object o) {
        return this.hashCode() - o.hashCode();
    }

    private class CancelListener
    extends EndpointListener<GeneralRPCProtos.Ack, ExecProtos.FragmentHandle> {
        public CancelListener(CoordinationProtos.DrillbitEndpoint endpoint, ExecProtos.FragmentHandle handle) {
            super(endpoint, handle);
        }

        @Override
        public void failed(RpcException ex) {
            logger.error("Failure while attempting to cancel fragment {} on endpoint {}.", this.value, this.endpoint, ex);
        }

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buf) {
            if (!value.getOk()) {
                logger.warn("Remote node {} responded negative on cancellation request for fragment {}.", (Object)this.endpoint, (Object)value);
            }
        }
    }

    private class ResponseSendListener
    extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
        private ResponseSendListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.info("Failure while trying communicate query result to initating client.  This would happen if a client is disconnected before response notice can be sent.", ex);
            Foreman.this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, ex);
        }
    }

    public class StateListener {
        public boolean moveToState(UserBitShared.QueryResult.QueryState newState, Exception ex) {
            try {
                Foreman.this.acceptExternalEvents.await();
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting to move state.", e);
                return false;
            }
            return Foreman.this.moveToState(newState, ex);
        }
    }

    private class FragmentSubmitListener
    extends EndpointListener<GeneralRPCProtos.Ack, BitControl.InitializeFragments> {
        private CountDownLatch latch;

        public FragmentSubmitListener(CoordinationProtos.DrillbitEndpoint endpoint, BitControl.InitializeFragments value, CountDownLatch latch) {
            super(endpoint, value);
            this.latch = latch;
        }

        @Override
        public void success(GeneralRPCProtos.Ack ack, ByteBuf byteBuf) {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        @Override
        public void failed(RpcException ex) {
            logger.debug("Failure while sending fragment.  Stopping query.", ex);
            Foreman.this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, ex);
        }
    }

    public static class PhysicalFromLogicalExplain {
        public String json;

        public PhysicalFromLogicalExplain(String json) {
            this.json = json;
        }
    }
}

