/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.work.batch.RawBatchBuffer;
import org.apache.drill.exec.work.batch.ResponseSenderQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlimitedRawBatchBuffer
implements RawBatchBuffer {
    static final Logger logger = LoggerFactory.getLogger(UnlimitedRawBatchBuffer.class);
    private final LinkedBlockingDeque<RawFragmentBatch> buffer;
    private volatile BufferState state;
    private final int softlimit;
    private final int startlimit;
    private final AtomicBoolean overlimit;
    private final AtomicBoolean outOfMemory;
    private final ResponseSenderQueue readController;
    private int streamCounter;
    private int fragmentCount;
    private FragmentContext context;

    @Override
    public void enqueue(RawFragmentBatch batch) throws IOException {
        if (this.state == BufferState.KILLED) {
            batch.release();
        }
        if (this.isFinished()) {
            if (this.state == BufferState.KILLED) {
                batch.release();
            } else {
                throw new IOException("Attempted to enqueue batch after finished");
            }
        }
        if (batch.getHeader().getIsOutOfMemory()) {
            BitData.FragmentRecordBatch header;
            logger.debug("Setting autoread false");
            RawFragmentBatch firstBatch = this.buffer.peekFirst();
            BitData.FragmentRecordBatch fragmentRecordBatch = header = firstBatch == null ? null : firstBatch.getHeader();
            if (!this.outOfMemory.get() && header != null && header.getIsOutOfMemory()) {
                this.buffer.addFirst(batch);
            }
            this.outOfMemory.set(true);
            return;
        }
        this.buffer.add(batch);
        if (this.buffer.size() == this.softlimit) {
            this.overlimit.set(true);
            this.readController.enqueueResponse(batch.getSender());
        } else {
            batch.sendOk();
        }
    }

    @Override
    public void cleanup() {
        if (!this.isFinished() && !this.context.isCancelled()) {
            String msg = String.format("Cleanup before finished. " + (this.fragmentCount - this.streamCounter) + " out of " + this.fragmentCount + " streams have finished.", new Object[0]);
            logger.error(msg);
            IllegalStateException e = new IllegalStateException(msg);
            this.context.fail(e);
            throw e;
        }
        if (!this.buffer.isEmpty()) {
            RawFragmentBatch batch;
            if (!this.context.isFailed() && !this.context.isCancelled()) {
                this.context.fail(new IllegalStateException("Batches still in queue during cleanup"));
                logger.error("{} Batches in queue.", (Object)this.buffer.size());
                while ((batch = this.buffer.poll()) != null) {
                    logger.error("Batch left in queue: {}", (Object)batch);
                }
            }
            while ((batch = this.buffer.poll()) != null) {
                if (batch.getBody() == null) continue;
                batch.getBody().release();
            }
        }
    }

    @Override
    public void kill(FragmentContext context) {
        this.state = BufferState.KILLED;
        while (!this.buffer.isEmpty()) {
            RawFragmentBatch batch = this.buffer.poll();
            if (batch.getBody() == null) continue;
            batch.getBody().release();
        }
    }

    public void finished() {
        if (this.state != BufferState.KILLED) {
            this.state = BufferState.FINISHED;
        }
        if (!this.buffer.isEmpty()) {
            throw new IllegalStateException("buffer not empty when finished");
        }
    }

    @Override
    public RawFragmentBatch getNext() {
        if (this.outOfMemory.get() && this.buffer.size() < 10) {
            logger.debug("Setting autoread true");
            this.outOfMemory.set(false);
            this.readController.flushResponses();
        }
        RawFragmentBatch b = null;
        b = this.buffer.poll();
        if (!(b != null || this.isFinished() && this.buffer.isEmpty())) {
            try {
                b = this.buffer.take();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        if (b != null && b.getHeader().getIsOutOfMemory()) {
            this.outOfMemory.set(true);
            return b;
        }
        if (!this.isFinished() && this.overlimit.get() && this.buffer.size() == this.startlimit) {
            this.overlimit.set(false);
            this.readController.flushResponses();
        }
        if (b != null && b.getHeader().getIsLastBatch()) {
            --this.streamCounter;
            if (this.streamCounter == 0) {
                this.finished();
            }
        }
        if (b == null && this.buffer.size() > 0) {
            throw new IllegalStateException("Returning null when there are batches left in queue");
        }
        if (b == null && !this.isFinished()) {
            throw new IllegalStateException("Returning null when not finished");
        }
        return b;
    }

    private boolean isFinished() {
        return this.state == BufferState.KILLED || this.state == BufferState.FINISHED;
    }

    private static enum BufferState {
        INIT,
        FINISHED,
        KILLED;

    }
}

