/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import com.google.common.collect.Queues;
import java.util.Queue;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseSenderQueue {
    static final Logger logger = LoggerFactory.getLogger(ResponseSenderQueue.class);
    private Queue<ResponseSender> q = Queues.newConcurrentLinkedQueue();

    public void enqueueResponse(ResponseSender sender) {
        this.q.add(sender);
    }

    public void flushResponses() {
        while (!this.q.isEmpty()) {
            ResponseSender s = this.q.poll();
            if (s == null) continue;
            s.send(DataRpcConfig.OK);
        }
    }
}

