/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.work.batch.AbstractDataCollector;
import org.apache.drill.exec.work.batch.DataCollector;
import org.apache.drill.exec.work.batch.MergingCollector;
import org.apache.drill.exec.work.batch.PartitionedCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingBuffers
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(IncomingBuffers.class);
    private final AtomicInteger streamsRemaining = new AtomicInteger(0);
    private final AtomicInteger remainingRequired = new AtomicInteger(0);
    private final Map<Integer, DataCollector> fragCounts;
    private final FragmentContext context;

    public IncomingBuffers(PhysicalOperator root, FragmentContext context) {
        this.context = context;
        HashMap counts = Maps.newHashMap();
        CountRequiredFragments reqFrags = new CountRequiredFragments();
        root.accept(reqFrags, counts);
        logger.debug("Came up with a list of {} required fragments.  Fragments {}", (Object)this.remainingRequired.get(), (Object)counts);
        this.fragCounts = ImmutableMap.copyOf(counts);
        int totalStreams = 0;
        for (DataCollector bc : this.fragCounts.values()) {
            totalStreams += bc.getTotalIncomingFragments();
        }
        assert (totalStreams >= this.remainingRequired.get()) : String.format("Total Streams %d should be more than the minimum number of streams to commence (%d).  It isn't.", totalStreams, this.remainingRequired.get());
        this.streamsRemaining.set(totalStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchArrived(RawFragmentBatch batch) throws FragmentSetupException, IOException {
        int sendMajorFragmentId;
        DataCollector fSet;
        if (batch.getHeader().getIsOutOfMemory()) {
            for (DataCollector fSet2 : this.fragCounts.values()) {
                fSet2.batchArrived(0, batch);
            }
            return false;
        }
        if (batch.getHeader().getIsLastBatch()) {
            this.streamsRemaining.decrementAndGet();
        }
        if ((fSet = this.fragCounts.get(sendMajorFragmentId = batch.getHeader().getSendingMajorFragmentId())) == null) {
            throw new FragmentSetupException(String.format("We received a major fragment id that we were not expecting.  The id was %d. %s", sendMajorFragmentId, Arrays.toString(this.fragCounts.values().toArray())));
        }
        IncomingBuffers incomingBuffers = this;
        synchronized (incomingBuffers) {
            boolean decremented = fSet.batchArrived(batch.getHeader().getSendingMinorFragmentId(), batch);
            return decremented && this.remainingRequired.get() == 0;
        }
    }

    public boolean isDone() {
        return this.streamsRemaining.get() < 1;
    }

    @Override
    public void close() {
        for (DataCollector fragment : this.fragCounts.values()) {
            fragment.close();
        }
    }

    public class CountRequiredFragments
    extends AbstractPhysicalVisitor<Void, Map<Integer, DataCollector>, RuntimeException> {
        @Override
        public Void visitReceiver(Receiver receiver, Map<Integer, DataCollector> counts) throws RuntimeException {
            AbstractDataCollector set = receiver.supportsOutOfOrderExchange() ? new MergingCollector(IncomingBuffers.this.remainingRequired, receiver, IncomingBuffers.this.context) : new PartitionedCollector(IncomingBuffers.this.remainingRequired, receiver, IncomingBuffers.this.context);
            counts.put(set.getOppositeMajorFragmentId(), set);
            IncomingBuffers.this.remainingRequired.incrementAndGet();
            return null;
        }

        @Override
        public Void visitOp(PhysicalOperator op, Map<Integer, DataCollector> value) throws RuntimeException {
            for (PhysicalOperator o : op) {
                o.accept(this, value);
            }
            return null;
        }
    }
}

