/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.work.batch.DataCollector;
import org.apache.drill.exec.work.batch.RawBatchBuffer;

public abstract class AbstractDataCollector
implements DataCollector {
    private final List<CoordinationProtos.DrillbitEndpoint> incoming;
    private final int oppositeMajorFragmentId;
    private final AtomicIntegerArray remainders;
    private final AtomicInteger remainingRequired;
    protected final RawBatchBuffer[] buffers;
    private final AtomicInteger parentAccounter;
    private final AtomicInteger finishedStreams = new AtomicInteger();
    private final FragmentContext context;

    public AbstractDataCollector(AtomicInteger parentAccounter, Receiver receiver, int minInputsRequired, FragmentContext context) {
        Preconditions.checkArgument(minInputsRequired > 0);
        Preconditions.checkNotNull(receiver);
        Preconditions.checkNotNull(parentAccounter);
        this.parentAccounter = parentAccounter;
        this.incoming = receiver.getProvidingEndpoints();
        this.remainders = new AtomicIntegerArray(this.incoming.size());
        this.oppositeMajorFragmentId = receiver.getOppositeMajorFragmentId();
        this.buffers = new RawBatchBuffer[minInputsRequired];
        this.context = context;
        try {
            String bufferClassName = context.getConfig().getString("drill.exec.buffer.impl");
            Constructor<?> bufferConstructor = Class.forName(bufferClassName).getConstructor(FragmentContext.class, Integer.TYPE);
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i] = (RawBatchBuffer)bufferConstructor.newInstance(context, receiver.supportsOutOfOrderExchange() ? this.incoming.size() : 1);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            context.fail(e);
        }
        this.remainingRequired = receiver.supportsOutOfOrderExchange() ? new AtomicInteger(1) : new AtomicInteger(minInputsRequired);
    }

    @Override
    public int getOppositeMajorFragmentId() {
        return this.oppositeMajorFragmentId;
    }

    @Override
    public boolean batchArrived(int minorFragmentId, RawFragmentBatch batch) throws IOException {
        int rem;
        if (batch.getHeader().getIsOutOfMemory()) {
            for (RawBatchBuffer buffer : this.buffers) {
                buffer.enqueue(batch);
            }
        }
        boolean decremented = false;
        if (this.remainders.compareAndSet(minorFragmentId, 0, 1) && (rem = this.remainingRequired.decrementAndGet()) == 0) {
            this.parentAccounter.decrementAndGet();
            decremented = true;
        }
        this.getBuffer(minorFragmentId).enqueue(batch);
        return decremented;
    }

    @Override
    public int getTotalIncomingFragments() {
        return this.incoming.size();
    }

    protected abstract RawBatchBuffer getBuffer(int var1);

    @Override
    public void close() {
    }
}

