/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.NamedThreadFactory;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.DataConnectionCreator;
import org.apache.drill.exec.rpc.data.DataResponseHandler;
import org.apache.drill.exec.rpc.data.DataResponseHandlerImpl;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.work.batch.ControlHandlerImpl;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.QueryStatus;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.exec.work.user.UserWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkManager
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(WorkManager.class);
    private Set<FragmentManager> incomingFragments = Collections.newSetFromMap(Maps.newConcurrentMap());
    private LinkedBlockingQueue<RunnableWrapper> pendingTasks = Queues.newLinkedBlockingQueue();
    private Map<ExecProtos.FragmentHandle, FragmentExecutor> runningFragments = Maps.newConcurrentMap();
    private ConcurrentMap<UserBitShared.QueryId, Foreman> queries = Maps.newConcurrentMap();
    private ConcurrentMap<UserBitShared.QueryId, QueryStatus> status = Maps.newConcurrentMap();
    private BootStrapContext bContext;
    private DrillbitContext dContext;
    private final ControlMessageHandler controlMessageWorker;
    private final DataResponseHandler dataHandler;
    private final UserWorker userWorker;
    private final WorkerBee bee = new WorkerBee();
    private final WorkEventBus workBus = new WorkEventBus(this.bee);
    private ExecutorService executor;
    private final EventThread eventThread;

    public WorkManager(BootStrapContext context) {
        this.bContext = context;
        this.controlMessageWorker = new ControlHandlerImpl(this.bee);
        this.userWorker = new UserWorker(this.bee);
        this.eventThread = new EventThread();
        this.dataHandler = new DataResponseHandlerImpl(this.bee);
    }

    public void start(CoordinationProtos.DrillbitEndpoint endpoint, Controller controller, DataConnectionCreator data, ClusterCoordinator coord, PStoreProvider provider) {
        this.dContext = new DrillbitContext(endpoint, this.bContext, coord, controller, data, this.workBus, provider);
        this.executor = Executors.newCachedThreadPool(new NamedThreadFactory("WorkManager-"));
        this.eventThread.start();
        try {
            this.dContext.getMetrics().register(MetricRegistry.name("drill.exec.work.running_fragments." + this.dContext.getEndpoint().getUserPort(), new String[0]), new Gauge<Integer>(){});
            this.dContext.getMetrics().register(MetricRegistry.name("drill.exec.work.pendingTasks" + this.dContext.getEndpoint().getUserPort(), new String[0]), new Gauge<Integer>(){});
        }
        catch (IllegalArgumentException e) {
            logger.warn("Exception while registering metrics", e);
        }
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public DataResponseHandler getDataHandler() {
        return this.dataHandler;
    }

    public ControlMessageHandler getControlMessageHandler() {
        return this.controlMessageWorker;
    }

    public UserWorker getUserWorker() {
        return this.userWorker;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.executor != null) {
                this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.warn("Executor interrupted while awaiting termination");
        }
    }

    public DrillbitContext getContext() {
        return this.dContext;
    }

    private static String getId(ExecProtos.FragmentHandle handle) {
        return "FragmentExecutor: " + QueryIdHelper.getQueryId(handle.getQueryId()) + ':' + handle.getMajorFragmentId() + ':' + handle.getMinorFragmentId();
    }

    private class RunnableWrapper
    implements Runnable {
        final Runnable inner;
        private final String id;

        public RunnableWrapper(Runnable r, String id) {
            this.inner = r;
            this.id = id;
        }

        @Override
        public void run() {
            try {
                this.inner.run();
            }
            catch (Error | Exception e) {
                logger.error("Failure while running wrapper [{}]", (Object)this.id, (Object)e);
            }
        }
    }

    private class EventThread
    extends Thread {
        public EventThread() {
            this.setDaemon(true);
            this.setName("WorkManager Event Thread");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    RunnableWrapper r;
                    if ((r = (RunnableWrapper)WorkManager.this.pendingTasks.take()) == null) {
                        continue;
                    }
                    logger.debug("Starting pending task {}", (Object)r);
                    if (r.inner instanceof FragmentExecutor) {
                        FragmentExecutor fragmentExecutor = (FragmentExecutor)r.inner;
                        WorkManager.this.runningFragments.put(fragmentExecutor.getContext().getHandle(), fragmentExecutor);
                    }
                    WorkManager.this.executor.execute(r);
                }
            }
            catch (InterruptedException e) {
                logger.info("Work Manager stopping as it was interrupted.");
                return;
            }
        }
    }

    public class WorkerBee {
        public void addFragmentRunner(FragmentExecutor runner) {
            logger.debug("Adding pending task {}", (Object)runner);
            RunnableWrapper wrapper = new RunnableWrapper(runner, WorkManager.getId(runner.getContext().getHandle()));
            WorkManager.this.pendingTasks.add(wrapper);
        }

        public void addNewForeman(Foreman foreman) {
            String id = "Foreman: " + QueryIdHelper.getQueryId(foreman.getQueryId());
            RunnableWrapper wrapper = new RunnableWrapper(foreman, id);
            WorkManager.this.pendingTasks.add(wrapper);
            WorkManager.this.queries.put(foreman.getQueryId(), foreman);
        }

        public void startFragmentPendingRemote(FragmentManager handler) {
            WorkManager.this.incomingFragments.remove(handler);
            FragmentExecutor runner = handler.getRunnable();
            RunnableWrapper wrapper = new RunnableWrapper(runner, WorkManager.getId(runner.getContext().getHandle()));
            WorkManager.this.pendingTasks.add(wrapper);
        }

        public FragmentExecutor getFragmentRunner(ExecProtos.FragmentHandle handle) {
            return (FragmentExecutor)WorkManager.this.runningFragments.get(handle);
        }

        public void removeFragment(ExecProtos.FragmentHandle handle) {
            WorkManager.this.runningFragments.remove(handle);
        }

        public Foreman getForemanForQueryId(UserBitShared.QueryId queryId) {
            return (Foreman)WorkManager.this.queries.get(queryId);
        }

        public void retireForeman(Foreman foreman) {
            WorkManager.this.queries.remove(foreman.getQueryId(), foreman);
        }

        public DrillbitContext getContext() {
            return WorkManager.this.dContext;
        }
    }
}

