/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work;

import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.RemoteRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHelper {
    static final Logger logger = LoggerFactory.getLogger(ErrorHelper.class);
    static final Pattern IGNORE = Pattern.compile("^(sun|com\\.sun|java).*");

    public static UserBitShared.DrillPBError logAndConvertMessageError(CoordinationProtos.DrillbitEndpoint endpoint, String message, Throwable t, Logger logger, boolean verbose) {
        UserBitShared.DrillPBError baseError = t instanceof RemoteRpcException ? ((RemoteRpcException)t).getRemoteError() : ErrorHelper.logAndConvertError(endpoint, message, t, logger);
        String userMessage = ErrorHelper.getErrorMessage(baseError, verbose);
        return UserBitShared.DrillPBError.newBuilder().setEndpoint(baseError.getEndpoint()).setErrorId(baseError.getErrorId()).setMessage(userMessage).build();
    }

    public static UserBitShared.DrillPBError logAndConvertError(CoordinationProtos.DrillbitEndpoint endpoint, String message, Throwable t, Logger logger) {
        String id = UUID.randomUUID().toString();
        UserBitShared.DrillPBError.Builder builder = UserBitShared.DrillPBError.newBuilder();
        builder.setEndpoint(endpoint);
        builder.setErrorId(id);
        if (message != null) {
            builder.setMessage(message);
        }
        if (t == null) {
            t = new DrillException("Undefined failure occurred.");
        }
        builder.setException(ErrorHelper.getWrapper(t));
        logger.error("Error {}: {}", id, message, t);
        return builder.build();
    }

    public static UserBitShared.ExceptionWrapper getWrapper(Throwable ex) {
        return ErrorHelper.getWrapperBuilder(ex).build();
    }

    public static UserBitShared.ExceptionWrapper.Builder getWrapperBuilder(Throwable ex) {
        return ErrorHelper.getWrapperBuilder(ex, false);
    }

    public static UserBitShared.ExceptionWrapper.Builder getWrapperBuilder(Throwable ex, boolean includeAllStack) {
        UserBitShared.ExceptionWrapper.Builder ew = UserBitShared.ExceptionWrapper.newBuilder();
        if (ex.getMessage() != null) {
            ew.setMessage(ex.getMessage());
        }
        ew.setExceptionClass(ex.getClass().getCanonicalName());
        boolean isHidden = false;
        UserBitShared.StackTraceElementWrapper[] wrappers = new UserBitShared.StackTraceElementWrapper[ex.getStackTrace().length];
        for (int i = 0; i < wrappers.length; ++i) {
            StackTraceElement ele = ex.getStackTrace()[i];
            if (ErrorHelper.include(ele, includeAllStack)) {
                if (isHidden) {
                    isHidden = false;
                }
                ew.addStackTrace(ErrorHelper.getSTWrapper(ele));
                continue;
            }
            if (isHidden) continue;
            isHidden = true;
            ew.addStackTrace(ErrorHelper.getEmptyST());
        }
        if (ex.getCause() != null && ex.getCause() != ex) {
            ew.setCause(ErrorHelper.getWrapper(ex.getCause()));
        }
        return ew;
    }

    private static boolean include(StackTraceElement ele, boolean includeAllStack) {
        if (includeAllStack) {
            return true;
        }
        return !IGNORE.matcher(ele.getClassName()).matches();
    }

    private static UserBitShared.StackTraceElementWrapper.Builder getEmptyST() {
        UserBitShared.StackTraceElementWrapper.Builder w = UserBitShared.StackTraceElementWrapper.newBuilder();
        w.setClassName("...");
        w.setIsNativeMethod(false);
        w.setLineNumber(0);
        w.setMethodName("...");
        return w;
    }

    public static UserBitShared.StackTraceElementWrapper.Builder getSTWrapper(StackTraceElement ele) {
        UserBitShared.StackTraceElementWrapper.Builder w = UserBitShared.StackTraceElementWrapper.newBuilder();
        w.setClassName(ele.getClassName());
        if (ele.getFileName() != null) {
            w.setFileName(ele.getFileName());
        }
        w.setIsNativeMethod(ele.isNativeMethod());
        w.setLineNumber(ele.getLineNumber());
        w.setMethodName(ele.getMethodName());
        return w;
    }

    public static String getErrorMessage(UserBitShared.DrillPBError error, boolean verbose) {
        String finalMessage = null;
        UserBitShared.ExceptionWrapper ex = error.getException();
        StringBuilder sb = new StringBuilder();
        sb.append("[ ").append(error.getErrorId()).append(" on ").append(error.getEndpoint().getAddress()).append(":").append(error.getEndpoint().getUserPort()).append(" ]\n");
        boolean cause = false;
        while (ex != null) {
            if (ex.hasMessage()) {
                finalMessage = ex.getMessage();
            }
            if (verbose) {
                sb.append("  ");
                if (cause) {
                    sb.append("Caused By ");
                }
                sb.append("(");
                sb.append(ex.getExceptionClass());
                sb.append(") ");
                sb.append(ex.getMessage());
                sb.append("\n");
                for (int i = 0; i < ex.getStackTraceCount(); ++i) {
                    UserBitShared.StackTraceElementWrapper st = ex.getStackTrace(i);
                    sb.append("    ");
                    sb.append(st.getClassName());
                    sb.append('.');
                    sb.append(st.getMethodName());
                    sb.append("():");
                    sb.append(st.getLineNumber());
                    sb.append("\n");
                }
                cause = true;
            }
            ex = ex.hasCause() ? ex.getCause() : null;
        }
        StringBuilder msg = new StringBuilder();
        if (error.hasMessage()) {
            msg.append(error.getMessage());
            if (finalMessage != null) {
                msg.append(", ");
                msg.append(finalMessage);
                msg.append(' ');
            }
        } else if (finalMessage != null) {
            msg.append(finalMessage);
            msg.append(' ');
        } else {
            msg.append("Error ");
        }
        msg.append((CharSequence)sb);
        return msg.toString();
    }
}

