/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.fn;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.google.common.base.Preconditions;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.store.easy.json.RewindableUtf8Reader;
import org.apache.drill.exec.vector.complex.fn.FieldSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReader {
    static final Logger logger = LoggerFactory.getLogger(JsonReader.class);
    private final RewindableUtf8Reader parser;
    private DrillBuf workBuf;
    private final List<SchemaPath> columns;
    private final boolean allTextMode;
    private boolean atLeastOneWrite = false;
    private FieldSelection selection;
    private boolean onReset = false;

    public JsonReader() throws IOException {
        this(null, false);
    }

    public JsonReader(DrillBuf managedBuf, boolean allTextMode) {
        this(managedBuf, GroupScan.ALL_COLUMNS, allTextMode);
    }

    public JsonReader(DrillBuf managedBuf, List<SchemaPath> columns, boolean allTextMode) {
        BufferRecycler recycler = new BufferRecycler();
        IOContext context = new IOContext(recycler, this, false);
        int features = JsonParser.Feature.collectDefaults() | JsonParser.Feature.ALLOW_COMMENTS.getMask() | JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES.getMask();
        BytesToNameCanonicalizer can = BytesToNameCanonicalizer.createRoot();
        this.parser = new RewindableUtf8Reader(context, features, can.makeChild(JsonFactory.Feature.collectDefaults()), context.allocReadIOBuffer());
        assert (Preconditions.checkNotNull(columns).size() > 0) : "json record reader requires at least a column";
        this.selection = FieldSelection.getFieldSelection(columns);
        this.workBuf = managedBuf;
        this.allTextMode = allTextMode;
        this.columns = columns;
    }

    public static enum ReadState {
        WRITE_FAILURE,
        END_OF_STREAM,
        WRITE_SUCCEED;

    }
}

