/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.fn;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;

class FieldSelection {
    public static final FieldSelection INVALID_NODE = new FieldSelection(null, ValidityMode.NEVER_VALID);
    public static final FieldSelection ALL_VALID = new FieldSelection(null, ValidityMode.ALWAYS_VALID);
    private final Map<String, FieldSelection> children;
    private final Map<String, FieldSelection> childrenInsensitive;
    private final ValidityMode mode;

    private FieldSelection() {
        this(new HashMap<String, FieldSelection>(), ValidityMode.CHECK_CHILDREN);
    }

    private FieldSelection(Map<String, FieldSelection> children, ValidityMode mode) {
        this.children = children;
        if (children != null) {
            this.childrenInsensitive = new TreeMap<String, FieldSelection>(String.CASE_INSENSITIVE_ORDER);
            this.childrenInsensitive.putAll(children);
        } else {
            this.childrenInsensitive = null;
        }
        this.mode = mode;
    }

    private FieldSelection fixNodes() {
        if (this.children.isEmpty()) {
            return ALL_VALID;
        }
        HashMap<String, FieldSelection> newMap = Maps.newHashMap();
        for (Map.Entry<String, FieldSelection> e : this.children.entrySet()) {
            newMap.put(e.getKey(), e.getValue().fixNodes());
        }
        return new FieldSelection(newMap, ValidityMode.CHECK_CHILDREN);
    }

    private FieldSelection addChild(String name) {
        if (this.children.containsKey(name = name.toLowerCase())) {
            return this.children.get(name);
        }
        FieldSelection n = new FieldSelection();
        this.children.put(name, n);
        return n;
    }

    private void add(PathSegment segment) {
        if (segment.isNamed()) {
            FieldSelection child = this.addChild(segment.getNameSegment().getPath());
            if (!segment.isLastPath()) {
                child.add(segment.getChild());
            }
        }
    }

    private static boolean containsStar(List<SchemaPath> columns) {
        for (SchemaPath expr : columns) {
            if (!expr.getRootSegment().getPath().equals("*")) continue;
            return true;
        }
        return false;
    }

    public static FieldSelection getFieldSelection(List<SchemaPath> fields) {
        if (FieldSelection.containsStar(fields)) {
            return ALL_VALID;
        }
        FieldSelection root = new FieldSelection();
        for (SchemaPath p : fields) {
            root.add(p.getRootSegment());
        }
        return root.fixNodes();
    }

    private static enum ValidityMode {
        CHECK_CHILDREN,
        NEVER_VALID,
        ALWAYS_VALID;

    }
}

