/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.AllocationHelper;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedMapReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatedMapVector
extends AbstractContainerVector
implements RepeatedFixedWidthVector {
    static final Logger logger = LoggerFactory.getLogger(RepeatedMapVector.class);
    public static final TypeProtos.MajorType TYPE = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.MAP).setMode(TypeProtos.DataMode.REPEATED).build();
    private final UInt4Vector offsets;
    private final Map<String, ValueVector> vectors = Maps.newLinkedHashMap();
    private final Map<String, AbstractContainerVector.VectorWithOrdinal> vectorIds = Maps.newHashMap();
    private final RepeatedMapReaderImpl reader = new RepeatedMapReaderImpl(this);
    private final IntObjectOpenHashMap<ValueVector> vectorsById = new IntObjectOpenHashMap();
    private final RepeatedMapAccessor accessor = new RepeatedMapAccessor();
    private final Mutator mutator = new Mutator();
    private final BufferAllocator allocator;
    private final MaterializedField field;
    private int lastPopulatedValueIndex = -1;
    private CallBack callBack;

    public RepeatedMapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this.field = field;
        this.allocator = allocator;
        this.offsets = new UInt4Vector(null, allocator);
        this.callBack = callBack;
    }

    @Override
    public void allocateNew(int topLevelValueCount, int childValueCount) {
        this.clear();
        this.offsets.allocateNew(topLevelValueCount + 1);
        this.offsets.zeroVector();
        for (ValueVector v : this.vectors.values()) {
            AllocationHelper.allocatePrecomputedChildCount(v, topLevelValueCount, 50, childValueCount);
        }
        this.mutator.reset();
        this.accessor.reset();
    }

    public Iterator<String> fieldNameIterator() {
        return this.vectors.keySet().iterator();
    }

    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        ValueVector v = this.vectors.get(name);
        if (v == null) {
            v = TypeHelper.getNewVector(this.field.getPath(), name, this.allocator, type);
            Preconditions.checkNotNull(v, String.format("Failure to create vector of type %s.", type));
            this.put(name, v);
            if (this.callBack != null) {
                this.callBack.doWork();
            }
        }
        return this.typeify(v, clazz);
    }

    @Override
    public int getBufferSize() {
        if (this.accessor.getGroupCount() == 0) {
            return 0;
        }
        long buffer = this.offsets.getBufferSize();
        for (ValueVector v : this) {
            buffer += (long)v.getBufferSize();
        }
        return (int)buffer;
    }

    @Override
    public void close() {
        for (ValueVector v : this) {
            v.close();
        }
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.vectors.values().iterator();
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair() {
        return new MapTransferPair(this.field.getPath());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new MapTransferPair((RepeatedMapVector)to);
    }

    @Override
    public void allocateNew() throws OutOfMemoryRuntimeException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.offsets.allocateNewSafe()) {
            return false;
        }
        this.offsets.zeroVector();
        for (ValueVector v : this.vectors.values()) {
            if (v.allocateNewSafe()) continue;
            return false;
        }
        return true;
    }

    @Override
    public RepeatedMapAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        int bufSize = this.getBufferSize();
        ArrayList<DrillBuf> bufs = Lists.newArrayList(this.offsets.getBuffers(clear));
        for (ValueVector v : this.vectors.values()) {
            for (DrillBuf b : v.getBuffers(clear)) {
                bufs.add(b);
            }
        }
        int actualBufSize = 0;
        for (DrillBuf b : bufs) {
            actualBufSize += b.writerIndex();
        }
        Preconditions.checkArgument(actualBufSize == bufSize);
        return bufs.toArray(new DrillBuf[bufs.size()]);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buf) {
        List<UserBitShared.SerializedField> fields = metadata.getChildList();
        int bufOffset = this.offsets.load(metadata.getGroupCount() + 1, buf);
        for (UserBitShared.SerializedField fmd : fields) {
            MaterializedField fieldDef = MaterializedField.create(fmd);
            ValueVector v = this.vectors.get(fieldDef.getLastName());
            if (v == null) {
                v = TypeHelper.getNewVector(fieldDef, this.allocator);
                this.put(fieldDef.getLastName(), v);
            }
            if (!(fmd.getValueCount() != 0 || fmd.hasGroupCount() && fmd.getGroupCount() != 0)) {
                v.clear();
            } else {
                v.load(fmd, buf.slice(bufOffset, fmd.getBufferLength()));
            }
            bufOffset += fmd.getBufferLength();
        }
        Preconditions.checkArgument(bufOffset == buf.capacity());
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setGroupCount(this.accessor.getGroupCount()).setValueCount(this.accessor.getGroupCount());
        for (ValueVector v : this.vectors.values()) {
            b.addChild(v.getMetadata());
        }
        return b.build();
    }

    protected void put(String name, ValueVector vv) {
        int ordinal = this.vectors.size();
        if (this.vectors.put(name, vv) != null) {
            throw new IllegalStateException();
        }
        this.vectorIds.put(name, new AbstractContainerVector.VectorWithOrdinal(vv, ordinal));
        this.vectorsById.put(ordinal, vv);
        this.field.addChild(vv.getField());
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    private void populateEmpties(int topLevelValueCount) {
        int previousEnd = this.offsets.getAccessor().get(this.lastPopulatedValueIndex + 1);
        for (int i = this.lastPopulatedValueIndex + 1; i < topLevelValueCount; ++i) {
            this.offsets.getMutator().setSafe(i + 1, previousEnd);
        }
        this.lastPopulatedValueIndex = topLevelValueCount - 1;
    }

    @Override
    public void clear() {
        this.getMutator().reset();
        this.offsets.clear();
        for (ValueVector v : this.vectors.values()) {
            v.clear();
        }
    }

    @Override
    public AbstractContainerVector.VectorWithOrdinal getVectorWithOrdinal(String name) {
        return this.vectorIds.get(name);
    }

    public class Mutator
    implements RepeatedFixedWidthVector.RepeatedMutator,
    ValueVector.Mutator {
        @Override
        public void setValueCount(int topLevelValueCount) {
            RepeatedMapVector.this.populateEmpties(topLevelValueCount);
            RepeatedMapVector.this.offsets.getMutator().setValueCount(topLevelValueCount == 0 ? 0 : topLevelValueCount + 1);
            int childValueCount = RepeatedMapVector.this.offsets.getAccessor().get(topLevelValueCount);
            for (ValueVector v : RepeatedMapVector.this.vectors.values()) {
                v.getMutator().setValueCount(childValueCount);
            }
        }

        public void reset() {
            RepeatedMapVector.this.lastPopulatedValueIndex = -1;
        }
    }

    public class RepeatedMapAccessor
    implements RepeatedFixedWidthVector.RepeatedAccessor {
        @Override
        public Object getObject(int index) {
            JsonStringArrayList<LinkedHashMap<String, Object>> l = new JsonStringArrayList<LinkedHashMap<String, Object>>();
            int end = RepeatedMapVector.this.offsets.getAccessor().get(index + 1);
            for (int i = RepeatedMapVector.this.offsets.getAccessor().get(index); i < end; ++i) {
                LinkedHashMap<String, Object> vv = Maps.newLinkedHashMap();
                for (Map.Entry e : RepeatedMapVector.this.vectors.entrySet()) {
                    ValueVector v = (ValueVector)e.getValue();
                    String k = (String)e.getKey();
                    Object value = v.getAccessor().getObject(i);
                    if (value == null) continue;
                    vv.put(k, value);
                }
                l.add(vv);
            }
            return l;
        }

        @Override
        public int getValueCount() {
            return RepeatedMapVector.this.offsets.getAccessor().get(RepeatedMapVector.this.offsets.getAccessor().getValueCount() - 1);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void reset() {
        }

        public int getGroupCount() {
            return RepeatedMapVector.this.offsets.getAccessor().getValueCount() - 1;
        }
    }

    private class MapTransferPair
    implements TransferPair {
        private final TransferPair[] pairs;
        private final RepeatedMapVector to;
        private final RepeatedMapVector from;

        public MapTransferPair(SchemaPath path) {
            this.from = RepeatedMapVector.this;
            RepeatedMapVector v = new RepeatedMapVector(MaterializedField.create(path, TYPE), RepeatedMapVector.this.allocator, RepeatedMapVector.this.callBack);
            this.pairs = new TransferPair[RepeatedMapVector.this.vectors.size()];
            int i = 0;
            for (Map.Entry e : RepeatedMapVector.this.vectors.entrySet()) {
                TransferPair otherSide = ((ValueVector)e.getValue()).getTransferPair();
                v.put((String)e.getKey(), otherSide.getTo());
                this.pairs[i++] = otherSide;
            }
            this.to = v;
        }

        public MapTransferPair(RepeatedMapVector to) {
            this.from = RepeatedMapVector.this;
            this.to = to;
            this.pairs = new TransferPair[RepeatedMapVector.this.vectors.size()];
            int i = 0;
            for (Map.Entry e : RepeatedMapVector.this.vectors.entrySet()) {
                int preSize = to.vectors.size();
                Object v = to.addOrGet((String)e.getKey(), ((ValueVector)e.getValue()).getField().getType(), ((ValueVector)e.getValue()).getClass());
                if (preSize != to.vectors.size()) {
                    v.allocateNew();
                }
                this.pairs[i++] = ((ValueVector)e.getValue()).makeTransferPair((ValueVector)v);
            }
        }

        @Override
        public void transfer() {
            RepeatedMapVector.this.offsets.transferTo(this.to.offsets);
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            RepeatedMapVector.this.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }
    }
}

