/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex;

import com.google.common.base.Preconditions;
import io.netty.buffer.DrillBuf;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedListReaderImpl;

public class RepeatedListVector
extends AbstractContainerVector
implements RepeatedFixedWidthVector {
    private final UInt4Vector offsets;
    private final BufferAllocator allocator;
    private final Mutator mutator = new Mutator();
    private final RepeatedListAccessor accessor = new RepeatedListAccessor();
    private ValueVector vector;
    private final MaterializedField field;
    private final RepeatedListReaderImpl reader = new RepeatedListReaderImpl(null, this);
    private int allocationValueCount = 4000;
    private int allocationMonitor = 0;
    private CallBack callBack;
    private int lastSet = 0;
    private int valueCount;
    public static TypeProtos.MajorType TYPE = Types.repeated(TypeProtos.MinorType.LIST);

    public RepeatedListVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this.allocator = allocator;
        this.offsets = new UInt4Vector(null, allocator);
        this.field = field;
        this.callBack = callBack;
    }

    public RepeatedListVector(SchemaPath path, BufferAllocator allocator, CallBack callBack) {
        this(MaterializedField.create(path, TYPE), allocator, callBack);
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() throws OutOfMemoryRuntimeException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.offsets.allocateNewSafe()) {
            return false;
        }
        this.offsets.zeroVector();
        if (this.vector != null) {
            return this.vector.allocateNewSafe();
        }
        return true;
    }

    @Override
    public int getBufferSize() {
        return this.offsets.getBufferSize() + this.vector.getBufferSize();
    }

    @Override
    public void close() {
        this.offsets.close();
        if (this.vector != null) {
            this.vector.close();
        }
    }

    @Override
    public void clear() {
        this.lastSet = 0;
        this.offsets.clear();
        if (this.vector != null) {
            this.vector.clear();
        }
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair() {
        return new RepeatedListTransferPair(this.field.getPath());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        if (!(to instanceof RepeatedListVector)) {
            throw new IllegalArgumentException("You can't make a transfer pair from an incompatible .");
        }
        return new RepeatedListTransferPair((RepeatedListVector)to);
    }

    @Override
    public RepeatedListAccessor getAccessor() {
        return this.accessor;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return ArrayUtils.addAll(this.offsets.getBuffers(clear), this.vector.getBuffers(clear));
    }

    private void setVector(ValueVector v) {
        this.field.addChild(v.getField());
        this.vector = v;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buf) {
        UserBitShared.SerializedField childField = metadata.getChildList().get(0);
        int bufOffset = this.offsets.load(metadata.getValueCount() + 1, buf);
        MaterializedField fieldDef = MaterializedField.create(childField);
        if (this.vector == null) {
            this.setVector(TypeHelper.getNewVector(fieldDef, this.allocator));
        }
        if (childField.getValueCount() == 0) {
            this.vector.clear();
        } else {
            this.vector.load(childField, buf.slice(bufOffset, childField.getBufferLength()));
        }
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.accessor.getGroupCount()).addChild(this.vector.getMetadata()).build();
    }

    private void populateEmpties(int groupCount) {
        int previousEnd = this.offsets.getAccessor().get(this.lastSet + 1);
        for (int i = this.lastSet + 2; i <= groupCount; ++i) {
            this.offsets.getMutator().setSafe(i, previousEnd);
        }
        this.lastSet = groupCount - 1;
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.vector).iterator();
    }

    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        Preconditions.checkArgument(name == null);
        if (this.vector == null) {
            this.vector = TypeHelper.getNewVector(MaterializedField.create(this.field.getPath().getUnindexedArrayChild(), type), this.allocator, this.callBack);
            if (this.callBack != null) {
                this.callBack.doWork();
            }
        }
        return this.typeify(this.vector, clazz);
    }

    @Override
    public void allocateNew(int parentValueCount, int childValueCount) {
        this.clear();
        this.offsets.allocateNew(parentValueCount + 1);
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public AbstractContainerVector.VectorWithOrdinal getVectorWithOrdinal(String name) {
        if (name != null) {
            return null;
        }
        return new AbstractContainerVector.VectorWithOrdinal(this.vector, 0);
    }

    public class RepeatedListTransferPair
    implements TransferPair {
        private final RepeatedListVector from;
        private final RepeatedListVector to;
        private final TransferPair vectorTransfer;

        private RepeatedListTransferPair(RepeatedListVector to) {
            this.from = RepeatedListVector.this;
            this.to = to;
            if (to.vector == null) {
                to.vector = to.addOrGet(null, RepeatedListVector.this.vector.getField().getType(), RepeatedListVector.this.vector.getClass());
                to.vector.allocateNew();
            }
            this.vectorTransfer = RepeatedListVector.this.vector.makeTransferPair(to.vector);
        }

        private RepeatedListTransferPair(SchemaPath path) {
            this.from = RepeatedListVector.this;
            this.to = new RepeatedListVector(path, RepeatedListVector.this.allocator, RepeatedListVector.this.callBack);
            this.vectorTransfer = RepeatedListVector.this.vector.getTransferPair();
            this.to.vector = this.vectorTransfer.getTo();
        }

        @Override
        public void transfer() {
            RepeatedListVector.this.offsets.transferTo(this.to.offsets);
            this.vectorTransfer.transfer();
            this.to.valueCount = RepeatedListVector.this.valueCount;
            RepeatedListVector.this.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }
    }

    public class RepeatedListAccessor
    implements RepeatedFixedWidthVector.RepeatedAccessor {
        @Override
        public Object getObject(int index) {
            JsonStringArrayList<Object> l = new JsonStringArrayList<Object>();
            int end = RepeatedListVector.this.offsets.getAccessor().get(index + 1);
            for (int i = RepeatedListVector.this.offsets.getAccessor().get(index); i < end; ++i) {
                l.add(RepeatedListVector.this.vector.getAccessor().getObject(i));
            }
            return l;
        }

        @Override
        public int getValueCount() {
            return RepeatedListVector.this.offsets.getAccessor().get(RepeatedListVector.this.offsets.getAccessor().getValueCount() - 1);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void reset() {
        }

        public int getGroupCount() {
            return RepeatedListVector.this.offsets.getAccessor().getValueCount() - 1;
        }
    }

    public class Mutator
    implements RepeatedFixedWidthVector.RepeatedMutator,
    ValueVector.Mutator {
        @Override
        public void setValueCount(int groupCount) {
            RepeatedListVector.this.populateEmpties(groupCount);
            RepeatedListVector.this.offsets.getMutator().setValueCount(groupCount + 1);
            if (RepeatedListVector.this.vector != null) {
                int valueCount = RepeatedListVector.this.offsets.getAccessor().get(groupCount);
                RepeatedListVector.this.vector.getMutator().setValueCount(valueCount);
            }
        }

        public void reset() {
            RepeatedListVector.this.lastSet = 0;
        }
    }
}

