/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.impl.SingleMapReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapVector
extends AbstractContainerVector {
    static final Logger logger = LoggerFactory.getLogger(MapVector.class);
    public static final TypeProtos.MajorType TYPE = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.MAP).setMode(TypeProtos.DataMode.REQUIRED).build();
    final HashMap<String, ValueVector> vectors = Maps.newLinkedHashMap();
    private final Map<String, AbstractContainerVector.VectorWithOrdinal> vectorIds = Maps.newHashMap();
    private final IntObjectOpenHashMap<ValueVector> vectorsById = new IntObjectOpenHashMap();
    private final SingleMapReaderImpl reader = new SingleMapReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private final BufferAllocator allocator;
    private MaterializedField field;
    private int valueCount;
    private CallBack callBack;

    public MapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        this.field = field;
        this.allocator = allocator;
        this.callBack = callBack;
    }

    public <T extends ValueVector> T addOrGet(String name, TypeProtos.MajorType type, Class<T> clazz) {
        ValueVector vector;
        while (true) {
            if ((vector = this.vectors.get(name)) == null) {
                vector = TypeHelper.getNewVector(this.field.getPath(), name, this.allocator, type);
                Preconditions.checkNotNull(vector, String.format("Failure to create vector of type %s.", type));
                this.put(name, vector);
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
            if (clazz.isAssignableFrom(vector.getClass())) {
                return (T)vector;
            }
            boolean allNulls = true;
            for (int i = 0; i < vector.getAccessor().getValueCount(); ++i) {
                if (vector.getAccessor().isNull(i)) continue;
                allNulls = false;
                break;
            }
            if (!allNulls) break;
            vector.clear();
            this.vectors.remove(name);
        }
        throw new IllegalStateException(String.format("Vector requested [%s] was different than type stored [%s].  Drill doesn't yet support hetergenous types.", clazz.getSimpleName(), vector.getClass().getSimpleName()));
    }

    protected void put(String name, ValueVector vv) {
        int ordinal = this.vectors.size();
        if (this.vectors.put(name, vv) != null) {
            throw new IllegalStateException();
        }
        this.vectorIds.put(name.toLowerCase(), new AbstractContainerVector.VectorWithOrdinal(vv, ordinal));
        this.vectorsById.put(ordinal, vv);
        this.field.addChild(vv.getField());
    }

    public Iterator<String> fieldNameIterator() {
        return this.vectors.keySet().iterator();
    }

    @Override
    public void allocateNew() throws OutOfMemoryRuntimeException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        for (ValueVector v : this.vectors.values()) {
            if (v.allocateNewSafe()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0 || this.vectors.isEmpty()) {
            return 0;
        }
        long buffer = 0L;
        for (ValueVector v : this) {
            buffer += (long)v.getBufferSize();
        }
        return (int)buffer;
    }

    @Override
    public void close() {
        for (ValueVector v : this) {
            v.close();
        }
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return this.vectors.values().iterator();
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair() {
        return new MapTransferPair(this.field.getPath());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new MapTransferPair((MapVector)to);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        ArrayList<DrillBuf> bufs = Lists.newArrayList();
        for (ValueVector v : this.vectors.values()) {
            for (DrillBuf b : v.getBuffers(clear)) {
                bufs.add(b);
            }
        }
        return bufs.toArray(new DrillBuf[bufs.size()]);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buf) {
        List<UserBitShared.SerializedField> fields = metadata.getChildList();
        this.valueCount = metadata.getValueCount();
        int bufOffset = 0;
        for (UserBitShared.SerializedField fmd : fields) {
            MaterializedField fieldDef = MaterializedField.create(fmd);
            ValueVector v = this.vectors.get(fieldDef.getLastName());
            if (v == null) {
                v = TypeHelper.getNewVector(fieldDef, this.allocator);
                this.put(fieldDef.getLastName(), v);
            }
            if (!(fmd.getValueCount() != 0 || fmd.hasGroupCount() && fmd.getGroupCount() != 0)) {
                v.clear();
            } else {
                v.load(fmd, buf.slice(bufOffset, fmd.getBufferLength()));
            }
            bufOffset += fmd.getBufferLength();
        }
        Preconditions.checkArgument(bufOffset == buf.capacity());
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.valueCount);
        for (ValueVector v : this.vectors.values()) {
            b.addChild(v.getMetadata());
        }
        return b.build();
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public ValueVector getVectorById(int id) {
        return (ValueVector)this.vectorsById.get(id);
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        for (ValueVector v : this.vectors.values()) {
            v.clear();
        }
    }

    @Override
    public AbstractContainerVector.VectorWithOrdinal getVectorWithOrdinal(String name) {
        return this.vectorIds.get(name.toLowerCase());
    }

    public class Mutator
    implements ValueVector.Mutator {
        @Override
        public void setValueCount(int valueCount) {
            for (ValueVector v : MapVector.this.vectors.values()) {
                v.getMutator().setValueCount(valueCount);
            }
            MapVector.this.valueCount = valueCount;
        }
    }

    public class Accessor
    implements ValueVector.Accessor {
        @Override
        public Object getObject(int index) {
            JsonStringHashMap<String, Object> vv = new JsonStringHashMap<String, Object>();
            for (Map.Entry<String, ValueVector> e : MapVector.this.vectors.entrySet()) {
                ValueVector v = e.getValue();
                String k = e.getKey();
                Object value = v.getAccessor().getObject(index);
                if (value == null) continue;
                vv.put(k, value);
            }
            return vv;
        }

        @Override
        public int getValueCount() {
            return MapVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }
    }

    private class MapTransferPair
    implements TransferPair {
        private MapVector from;
        private TransferPair[] pairs;
        private MapVector to;

        public MapTransferPair(SchemaPath path) {
            this.from = MapVector.this;
            MapVector v = new MapVector(MaterializedField.create(path, TYPE), MapVector.this.allocator, MapVector.this.callBack);
            this.pairs = new TransferPair[MapVector.this.vectors.size()];
            int i = 0;
            for (Map.Entry<String, ValueVector> e : MapVector.this.vectors.entrySet()) {
                TransferPair otherSide = e.getValue().getTransferPair();
                v.put(e.getKey(), otherSide.getTo());
                this.pairs[i++] = otherSide;
            }
            this.to = v;
        }

        public MapTransferPair(MapVector to) {
            this.from = MapVector.this;
            this.to = to;
            this.pairs = new TransferPair[MapVector.this.vectors.size()];
            int i = 0;
            for (Map.Entry<String, ValueVector> e : MapVector.this.vectors.entrySet()) {
                int preSize = to.vectors.size();
                Object v = to.addOrGet(e.getKey(), e.getValue().getField().getType(), e.getValue().getClass());
                if (to.vectors.size() != preSize) {
                    v.allocateNew();
                }
                this.pairs[i++] = e.getValue().makeTransferPair((ValueVector)v);
            }
        }

        @Override
        public void transfer() {
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            this.to.valueCount = MapVector.this.valueCount;
            MapVector.this.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }
    }
}

