/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex;

import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerVector
implements ValueVector {
    static final Logger logger = LoggerFactory.getLogger(AbstractContainerVector.class);

    protected <T extends ValueVector> T typeify(ValueVector v, Class<T> clazz) {
        if (clazz.isAssignableFrom(v.getClass())) {
            return (T)v;
        }
        throw new IllegalStateException(String.format("Vector requested [%s] was different than type stored [%s].  Drill doesn't yet support hetergenous types.", clazz.getSimpleName(), v.getClass().getSimpleName()));
    }

    public abstract VectorWithOrdinal getVectorWithOrdinal(String var1);

    public TypedFieldId getFieldIdIfMatches(TypedFieldId.Builder builder, boolean addToBreadCrumb, PathSegment seg) {
        VectorWithOrdinal vord;
        if (seg == null) {
            if (addToBreadCrumb) {
                builder.intermediateType(this.getField().getType());
            }
            return builder.finalType(this.getField().getType()).build();
        }
        if (seg.isArray()) {
            if (seg.isLastPath()) {
                builder.withIndex().finalType(this.getLastPathType());
                if (addToBreadCrumb) {
                    addToBreadCrumb = false;
                    builder.remainder(seg);
                }
                return builder.build();
            }
            if (addToBreadCrumb) {
                addToBreadCrumb = false;
                builder.remainder(seg);
            }
            seg = seg.getChild();
        }
        if ((vord = this.getVectorWithOrdinal(seg.isArray() ? null : seg.getNameSegment().getPath())) == null) {
            return null;
        }
        ValueVector v = vord.vector;
        if (addToBreadCrumb) {
            builder.intermediateType(v.getField().getType());
            builder.addId(vord.ordinal);
        }
        if (v instanceof AbstractContainerVector) {
            AbstractContainerVector c = (AbstractContainerVector)v;
            return c.getFieldIdIfMatches(builder, addToBreadCrumb, seg.getChild());
        }
        if (seg.isNamed()) {
            if (addToBreadCrumb) {
                builder.intermediateType(v.getField().getType());
            }
            builder.finalType(v.getField().getType());
        } else {
            builder.finalType(v.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
        }
        if (seg.isLastPath()) {
            return builder.build();
        }
        PathSegment child = seg.getChild();
        if (child.isLastPath() && child.isArray()) {
            if (addToBreadCrumb) {
                builder.remainder(child);
            }
            builder.withIndex();
            builder.finalType(v.getField().getType().toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build());
            return builder.build();
        }
        logger.warn("You tried to request a complex type inside a scalar object or path or type is wrong.");
        return null;
    }

    private TypeProtos.MajorType getLastPathType() {
        if (this.getField().getType().getMinorType() == TypeProtos.MinorType.LIST && this.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            VectorWithOrdinal vord = this.getVectorWithOrdinal(null);
            ValueVector v = vord.vector;
            if (!(v instanceof AbstractContainerVector)) {
                return v.getField().getType();
            }
        } else if (this.getField().getType().getMinorType() == TypeProtos.MinorType.MAP && this.getField().getType().getMode() == TypeProtos.DataMode.REPEATED) {
            return this.getField().getType().toBuilder().setMode(TypeProtos.DataMode.REQUIRED).build();
        }
        return this.getField().getType();
    }

    protected class VectorWithOrdinal {
        final ValueVector vector;
        final int ordinal;

        public VectorWithOrdinal(ValueVector v, int ordinal) {
            this.vector = v;
            this.ordinal = ordinal;
        }
    }
}

