/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class NullableVarBinaryAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VARBINARY);
    private final NullableVarBinaryVector.Accessor ac;

    public NullableVarBinaryAccessor(NullableVarBinaryVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public Object getObject(int index) {
        return this.ac.getObject(index);
    }

    @Override
    public InputStream getStream(int index) {
        NullableVarBinaryHolder h = new NullableVarBinaryHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream(h.buffer.slice(h.start, h.end));
    }

    @Override
    public byte[] getBytes(int index) {
        return this.ac.get(index);
    }

    @Override
    public String getString(int index) {
        byte[] b = this.ac.get(index);
        return DrillStringUtils.toBinaryString(b);
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    TypeProtos.MajorType getType() {
        return TYPE;
    }
}

