/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.base.Charsets;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueHolderHelper {
    static final Logger logger = LoggerFactory.getLogger(ValueHolderHelper.class);

    public static IntHolder getIntHolder(int value) {
        IntHolder holder = new IntHolder();
        holder.value = value;
        return holder;
    }

    public static BigIntHolder getBigIntHolder(long value) {
        BigIntHolder holder = new BigIntHolder();
        holder.value = value;
        return holder;
    }

    public static Float8Holder getFloat8Holder(double value) {
        Float8Holder holder = new Float8Holder();
        holder.value = value;
        return holder;
    }

    public static BitHolder getBitHolder(int value) {
        BitHolder holder = new BitHolder();
        holder.value = value;
        return holder;
    }

    public static NullableBitHolder getNullableBitHolder(boolean isNull, int value) {
        NullableBitHolder holder = new NullableBitHolder();
        int n = holder.isSet = isNull ? 0 : 1;
        if (!isNull) {
            holder.value = value;
        }
        return holder;
    }

    public static VarCharHolder getVarCharHolder(DrillBuf buf, String s) {
        VarCharHolder vch = new VarCharHolder();
        byte[] b = s.getBytes(Charsets.UTF_8);
        vch.start = 0;
        vch.end = b.length;
        vch.buffer = buf.reallocIfNeeded(b.length);
        vch.buffer.setBytes(0, b);
        return vch;
    }
}

