/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.UInt2ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class UInt2Vector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public UInt2Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 2.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 2);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 2);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 2;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 2;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UInt2Vector)to);
    }

    public void transferTo(UInt2Vector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = UInt2Vector.this.getValueCapacity();
            UInt2Vector.this.valueCount = valueCount;
            int idx = 2 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                UInt2Vector.this.incrementAllocationMonitor();
            } else if (UInt2Vector.this.allocationMonitor > 0) {
                UInt2Vector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(UInt2Vector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new UInt2ReaderImpl(UInt2Vector.this);
        }

        @Override
        public int getValueCount() {
            return UInt2Vector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public char get(int index) {
            return UInt2Vector.this.data.getChar(index * 2);
        }

        @Override
        public Character getObject(int index) {
            return Character.valueOf(this.get(index));
        }
    }

    private class TransferImpl
    implements TransferPair {
        UInt2Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new UInt2Vector(field, UInt2Vector.this.allocator);
        }

        public TransferImpl(UInt2Vector to) {
            this.to = to;
        }

        @Override
        public UInt2Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UInt2Vector.this.transferTo(this.to);
        }
    }
}

