/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.NullableTimeStampTZHolder;
import org.apache.drill.exec.expr.holders.TimeStampTZHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.TimeStampTZReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.DateTime;

public final class TimeStampTZVector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public TimeStampTZVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 12.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 12);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 12);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 12;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 12;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TimeStampTZVector)to);
    }

    public void transferTo(TimeStampTZVector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = TimeStampTZVector.this.getValueCapacity();
            TimeStampTZVector.this.valueCount = valueCount;
            int idx = 12 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                TimeStampTZVector.this.incrementAllocationMonitor();
            } else if (TimeStampTZVector.this.allocationMonitor > 0) {
                TimeStampTZVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(TimeStampTZVector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new TimeStampTZReaderImpl(TimeStampTZVector.this);
        }

        @Override
        public int getValueCount() {
            return TimeStampTZVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void get(int index, TimeStampTZHolder holder) {
            holder.value = TimeStampTZVector.this.data.getLong(index * 12);
            holder.index = TimeStampTZVector.this.data.getInt(index * 12 + 8);
        }

        public void get(int index, NullableTimeStampTZHolder holder) {
            holder.isSet = 1;
            holder.value = TimeStampTZVector.this.data.getLong(index * 12);
            holder.index = TimeStampTZVector.this.data.getInt(index * 12 + 8);
        }

        @Override
        public DateTime getObject(int index) {
            long l = TimeStampTZVector.this.data.getLong(index * 12);
            DateTime t = new DateTime(l);
            return t;
        }
    }

    private class TransferImpl
    implements TransferPair {
        TimeStampTZVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new TimeStampTZVector(field, TimeStampTZVector.this.allocator);
        }

        public TransferImpl(TimeStampTZVector to) {
            this.to = to;
        }

        @Override
        public TimeStampTZVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeStampTZVector.this.transferTo(this.to);
        }
    }
}

