/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.util.List;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.RepeatedMutator;
import org.apache.drill.exec.vector.RepeatedVariableWidthVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.Var16CharVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedVar16CharReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedVar16CharVector
extends BaseValueVector
implements RepeatedVariableWidthVector {
    private int parentValueCount;
    private int childValueCount;
    private final UInt4Vector offsets;
    private final Var16CharVector values;
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedVar16CharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.offsets = new UInt4Vector(null, allocator);
        MaterializedField mf = MaterializedField.create(field.getPath(), Types.required(field.getType().getMinorType()));
        this.values = new Var16CharVector(mf, allocator);
    }

    @Override
    public int getBufferSize() {
        if (this.accessor.getGroupCount() == 0) {
            return 0;
        }
        return this.offsets.getBufferSize() + this.values.getBufferSize();
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedVar16CharVector)to);
    }

    public void transferTo(RepeatedVar16CharVector target) {
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        target.parentValueCount = this.parentValueCount;
        target.childValueCount = this.childValueCount;
        this.clear();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.offsets.allocateNewSafe()) {
            return false;
        }
        this.offsets.zeroVector();
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        this.offsets.allocateNew();
        this.offsets.zeroVector();
        this.values.allocateNew();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setGroupCount(this.parentValueCount).setValueCount(this.childValueCount).setVarByteLength(this.values.getVarByteLength()).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew(int totalBytes, int parentValueCount, int childValueCount) {
        this.offsets.allocateNew(parentValueCount + 1);
        this.offsets.zeroVector();
        this.values.allocateNew(totalBytes, childValueCount);
        this.mutator.reset();
        this.accessor.reset();
    }

    public int load(int dataBytes, int parentValueCount, int childValueCount, DrillBuf buf) {
        this.clear();
        this.parentValueCount = parentValueCount;
        this.childValueCount = childValueCount;
        int loaded = 0;
        loaded += this.offsets.load(parentValueCount + 1, buf.slice(loaded, buf.capacity() - loaded));
        loaded += this.values.load(dataBytes + 4 * (childValueCount + 1), childValueCount, buf.slice(loaded, buf.capacity() - loaded));
        return loaded;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getVarByteLength(), metadata.getGroupCount(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsets.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.values.clear();
        this.parentValueCount = 0;
        this.childValueCount = 0;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    public final class Mutator
    implements RepeatedMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int groupCount) {
            RepeatedVar16CharVector.this.parentValueCount = groupCount;
            RepeatedVar16CharVector.this.childValueCount = RepeatedVar16CharVector.this.offsets.getAccessor().get(groupCount);
            RepeatedVar16CharVector.this.offsets.getMutator().setValueCount(groupCount == 0 ? 0 : groupCount + 1);
            RepeatedVar16CharVector.this.values.getMutator().setValueCount(RepeatedVar16CharVector.this.childValueCount);
        }

        public void reset() {
        }
    }

    public final class Accessor
    implements RepeatedFixedWidthVector.RepeatedAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new RepeatedVar16CharReaderImpl(RepeatedVar16CharVector.this);
        }

        @Override
        public List<String> getObject(int index) {
            JsonStringArrayList<String> vals = new JsonStringArrayList<String>();
            int start = RepeatedVar16CharVector.this.offsets.getAccessor().get(index);
            int end = RepeatedVar16CharVector.this.offsets.getAccessor().get(index + 1);
            for (int i = start; i < end; ++i) {
                vals.add(RepeatedVar16CharVector.this.values.getAccessor().getObject(i));
            }
            return vals;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int getGroupCount() {
            return RepeatedVar16CharVector.this.parentValueCount;
        }

        @Override
        public int getValueCount() {
            return RepeatedVar16CharVector.this.childValueCount;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        RepeatedVar16CharVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedVar16CharVector(field, RepeatedVar16CharVector.this.allocator);
        }

        public TransferImpl(RepeatedVar16CharVector to) {
            this.to = to;
        }

        @Override
        public RepeatedVar16CharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedVar16CharVector.this.transferTo(this.to);
        }
    }
}

