/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.util.List;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.Decimal18Vector;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.RepeatedDecimal18ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class RepeatedDecimal18Vector
extends BaseValueVector
implements RepeatedFixedWidthVector {
    private int parentValueCount;
    private int childValueCount;
    private final UInt4Vector offsets;
    private final Decimal18Vector values;
    private final Mutator mutator = new Mutator();
    private final Accessor accessor = new Accessor();

    public RepeatedDecimal18Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.offsets = new UInt4Vector(null, allocator);
        MaterializedField mf = MaterializedField.create(field.getPath(), Types.required(field.getType().getMinorType()));
        this.values = new Decimal18Vector(mf, allocator);
    }

    @Override
    public int getBufferSize() {
        if (this.accessor.getGroupCount() == 0) {
            return 0;
        }
        return this.offsets.getBufferSize() + this.values.getBufferSize();
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((RepeatedDecimal18Vector)to);
    }

    public void transferTo(RepeatedDecimal18Vector target) {
        this.offsets.transferTo(target.offsets);
        this.values.transferTo(target.values);
        target.parentValueCount = this.parentValueCount;
        target.childValueCount = this.childValueCount;
        this.clear();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.offsets.allocateNewSafe()) {
            return false;
        }
        this.offsets.zeroVector();
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew() {
        this.offsets.allocateNew();
        this.offsets.zeroVector();
        this.values.allocateNew();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setGroupCount(this.parentValueCount).setValueCount(this.childValueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew(int parentValueCount, int childValueCount) {
        this.clear();
        this.offsets.allocateNew(parentValueCount + 1);
        this.offsets.zeroVector();
        this.values.allocateNew(childValueCount);
        this.mutator.reset();
        this.accessor.reset();
    }

    public int load(int parentValueCount, int childValueCount, DrillBuf buf) {
        this.clear();
        this.parentValueCount = parentValueCount;
        this.childValueCount = childValueCount;
        int loaded = 0;
        loaded += this.offsets.load(parentValueCount + 1, buf.slice(loaded, buf.capacity() - loaded));
        loaded += this.values.load(childValueCount, buf.slice(loaded, buf.capacity() - loaded));
        return loaded;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getGroupCount(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsets.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.values.clear();
        this.parentValueCount = 0;
        this.childValueCount = 0;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    public final class Mutator
    implements RepeatedFixedWidthVector.RepeatedMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int groupCount) {
            RepeatedDecimal18Vector.this.parentValueCount = groupCount;
            RepeatedDecimal18Vector.this.childValueCount = RepeatedDecimal18Vector.this.offsets.getAccessor().get(groupCount);
            RepeatedDecimal18Vector.this.offsets.getMutator().setValueCount(groupCount == 0 ? 0 : groupCount + 1);
            RepeatedDecimal18Vector.this.values.getMutator().setValueCount(RepeatedDecimal18Vector.this.childValueCount);
        }

        public void reset() {
        }
    }

    public final class Accessor
    implements RepeatedFixedWidthVector.RepeatedAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new RepeatedDecimal18ReaderImpl(RepeatedDecimal18Vector.this);
        }

        @Override
        public List<BigDecimal> getObject(int index) {
            JsonStringArrayList<BigDecimal> vals = new JsonStringArrayList<BigDecimal>();
            int start = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index);
            int end = RepeatedDecimal18Vector.this.offsets.getAccessor().get(index + 1);
            for (int i = start; i < end; ++i) {
                vals.add(RepeatedDecimal18Vector.this.values.getAccessor().getObject(i));
            }
            return vals;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int getGroupCount() {
            return RepeatedDecimal18Vector.this.parentValueCount;
        }

        @Override
        public int getValueCount() {
            return RepeatedDecimal18Vector.this.childValueCount;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        RepeatedDecimal18Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new RepeatedDecimal18Vector(field, RepeatedDecimal18Vector.this.allocator);
        }

        public TransferImpl(RepeatedDecimal18Vector to) {
            this.to = to;
        }

        @Override
        public RepeatedDecimal18Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            RepeatedDecimal18Vector.this.transferTo(this.to);
        }
    }
}

