/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.ValueVector;

public class ObjectVector
extends BaseValueVector {
    private Accessor accessor = new Accessor();
    private Mutator mutator = new Mutator();
    private int maxCount = 0;
    private int count = 0;
    private int allocationSize = 4096;
    private List<Object[]> objectArrayList = new ArrayList<Object[]>();

    public ObjectVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public void addNewArray() {
        this.objectArrayList.add(new Object[this.allocationSize]);
        this.maxCount += this.allocationSize;
    }

    @Override
    public void allocateNew() throws OutOfMemoryRuntimeException {
        this.addNewArray();
    }

    @Override
    public boolean allocateNewSafe() {
        this.allocateNew();
        return true;
    }

    @Override
    public int getBufferSize() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.objectArrayList.clear();
        this.maxCount = 0;
        this.count = 0;
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Iterator<ValueVector> iterator() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public Object getObject(int index) {
            int listOffset = index / ObjectVector.this.allocationSize;
            if (listOffset >= ObjectVector.this.objectArrayList.size()) {
                ObjectVector.this.addNewArray();
            }
            return ((Object[])ObjectVector.this.objectArrayList.get(listOffset))[index % ObjectVector.this.allocationSize];
        }

        @Override
        public int getValueCount() {
            return ObjectVector.this.count;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }
    }

    public final class Mutator
    implements ValueVector.Mutator {
        @Override
        public void setValueCount(int valueCount) {
            ObjectVector.this.count = valueCount;
        }
    }
}

