/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.complex.impl.NullableVarCharReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.hadoop.io.Text;

public final class NullableVarCharVector
extends BaseValueVector
implements NullableVector,
VariableWidthVector {
    private int valueCount;
    final UInt1Vector bits;
    final VarCharVector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableVarCharVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new VarCharVector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setVarByteLength(this.values.getVarByteLength()).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        this.values.allocateNew(totalBytes, valueCount);
        this.bits.allocateNew(valueCount);
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    public int load(int dataBytes, int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        dataBytes -= loaded;
        this.mutator.lastSet = valueCount;
        return loaded += this.values.load(dataBytes, valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getBufferLength(), metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableVarCharVector)to);
    }

    public void transferTo(NullableVarCharVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        target.mutator.lastSet = this.mutator.lastSet;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator,
    VariableWidthVector.VariableWidthMutator {
        private int setCount;
        private int lastSet = -1;

        private Mutator() {
        }

        private boolean fillEmpties(int index) {
            for (int i = this.lastSet + 1; i < index; ++i) {
                if (NullableVarCharVector.this.values.getMutator().setSafe(i, new byte[0])) continue;
                return false;
            }
            this.lastSet = index;
            return true;
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            this.fillEmpties(valueCount);
            NullableVarCharVector.this.valueCount = valueCount;
            NullableVarCharVector.this.values.getMutator().setValueCount(valueCount);
            NullableVarCharVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
            this.lastSet = -1;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor,
    VariableWidthVector.VariableWidthAccessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final VarCharVector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableVarCharReaderImpl(NullableVarCharVector.this);
            this.bAccessor = NullableVarCharVector.this.bits.getAccessor();
            this.vAccessor = NullableVarCharVector.this.values.getAccessor();
        }

        public byte[] get(int index) {
            assert (!this.isNull(index)) : "Tried to get null value";
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableVarCharHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
        }

        public Text getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableVarCharVector.this.valueCount;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableVarCharVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableVarCharVector(field, NullableVarCharVector.this.allocator);
        }

        public TransferImpl(NullableVarCharVector to) {
            this.to = to;
        }

        @Override
        public NullableVarCharVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableVarCharVector.this.transferTo(this.to);
        }
    }
}

