/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.UInt8Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableUInt8ReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableUInt8Vector
extends BaseValueVector
implements FixedWidthVector,
NullableVector {
    private int valueCount;
    final UInt1Vector bits;
    final UInt8Vector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableUInt8Vector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new UInt8Vector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        this.values.allocateNew();
        this.bits.allocateNew();
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.values.allocateNew(valueCount);
        this.bits.allocateNew(valueCount);
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        return loaded += this.values.load(valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableUInt8Vector)to);
    }

    public void transferTo(NullableUInt8Vector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator {
        private int setCount;

        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableUInt8Vector.this.valueCount = valueCount;
            NullableUInt8Vector.this.values.getMutator().setValueCount(valueCount);
            NullableUInt8Vector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final UInt8Vector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableUInt8ReaderImpl(NullableUInt8Vector.this);
            this.bAccessor = NullableUInt8Vector.this.bits.getAccessor();
            this.vAccessor = NullableUInt8Vector.this.values.getAccessor();
        }

        public long get(int index) {
            assert (!this.isNull(index)) : "Tried to get null value";
            return this.vAccessor.get(index);
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        @Override
        public Long getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableUInt8Vector.this.valueCount;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableUInt8Vector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableUInt8Vector(field, NullableUInt8Vector.this.allocator);
        }

        public TransferImpl(NullableUInt8Vector to) {
            this.to = to;
        }

        @Override
        public NullableUInt8Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableUInt8Vector.this.transferTo(this.to);
        }
    }
}

