/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.ObjectArrays;
import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.Decimal28SparseVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.NullableVector;
import org.apache.drill.exec.vector.UInt1Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal28SparseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class NullableDecimal28SparseVector
extends BaseValueVector
implements FixedWidthVector,
NullableVector {
    private int valueCount;
    final UInt1Vector bits;
    final Decimal28SparseVector values;
    private final Accessor accessor;
    private final Mutator mutator;

    public NullableDecimal28SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.bits = new UInt1Vector(null, allocator);
        this.values = new Decimal28SparseVector(field, allocator);
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.bits.getBuffers(clear), this.values.getBuffers(clear), DrillBuf.class);
        if (clear) {
            this.clear();
        }
        return buffers;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.bits.clear();
        this.values.clear();
    }

    @Override
    public int getBufferSize() {
        return this.values.getBufferSize() + this.bits.getBufferSize();
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void allocateNew() {
        this.values.allocateNew();
        this.bits.allocateNew();
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    @Override
    public boolean allocateNewSafe() {
        if (!this.values.allocateNewSafe()) {
            return false;
        }
        if (!this.bits.allocateNewSafe()) {
            return false;
        }
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.values.allocateNew(valueCount);
        this.bits.allocateNew(valueCount);
        this.bits.zeroVector();
        this.mutator.reset();
        this.accessor.reset();
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int loaded = this.bits.load(valueCount, buf);
        buf = buf.slice(loaded, buf.capacity() - loaded);
        return loaded += this.values.load(valueCount, buf);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((NullableDecimal28SparseVector)to);
    }

    public void transferTo(NullableDecimal28SparseVector target) {
        this.bits.transferTo(target.bits);
        this.values.transferTo(target.values);
        target.valueCount = this.valueCount;
        this.clear();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public final class Mutator
    implements ValueVector.Mutator {
        private int setCount;

        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            assert (valueCount >= 0);
            NullableDecimal28SparseVector.this.valueCount = valueCount;
            NullableDecimal28SparseVector.this.values.getMutator().setValueCount(valueCount);
            NullableDecimal28SparseVector.this.bits.getMutator().setValueCount(valueCount);
        }

        public void reset() {
            this.setCount = 0;
        }
    }

    public final class Accessor
    implements ValueVector.Accessor {
        final FieldReader reader;
        final UInt1Vector.Accessor bAccessor;
        final Decimal28SparseVector.Accessor vAccessor;

        public Accessor() {
            this.reader = new NullableDecimal28SparseReaderImpl(NullableDecimal28SparseVector.this);
            this.bAccessor = NullableDecimal28SparseVector.this.bits.getAccessor();
            this.vAccessor = NullableDecimal28SparseVector.this.values.getAccessor();
        }

        @Override
        public boolean isNull(int index) {
            return this.isSet(index) == 0;
        }

        public int isSet(int index) {
            return this.bAccessor.get(index);
        }

        public void get(int index, NullableDecimal28SparseHolder holder) {
            this.vAccessor.get(index, holder);
            holder.isSet = this.bAccessor.get(index);
            holder.scale = NullableDecimal28SparseVector.this.getField().getScale();
            holder.precision = NullableDecimal28SparseVector.this.getField().getPrecision();
        }

        @Override
        public BigDecimal getObject(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.vAccessor.getObject(index);
        }

        @Override
        public int getValueCount() {
            return NullableDecimal28SparseVector.this.valueCount;
        }

        public void reset() {
        }
    }

    private class TransferImpl
    implements TransferPair {
        NullableDecimal28SparseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new NullableDecimal28SparseVector(field, NullableDecimal28SparseVector.this.allocator);
        }

        public TransferImpl(NullableDecimal28SparseVector to) {
            this.to = to;
        }

        @Override
        public NullableDecimal28SparseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            NullableDecimal28SparseVector.this.transferTo(this.to);
        }
    }
}

