/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.IntervalYearReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.Period;

public final class IntervalYearVector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public IntervalYearVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 4.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 4);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 4);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 4;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 4;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalYearVector)to);
    }

    public void transferTo(IntervalYearVector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalYearVector.this.getValueCapacity();
            IntervalYearVector.this.valueCount = valueCount;
            int idx = 4 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalYearVector.this.incrementAllocationMonitor();
            } else if (IntervalYearVector.this.allocationMonitor > 0) {
                IntervalYearVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(IntervalYearVector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new IntervalYearReaderImpl(IntervalYearVector.this);
        }

        @Override
        public int getValueCount() {
            return IntervalYearVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int get(int index) {
            return IntervalYearVector.this.data.getInt(index * 4);
        }

        @Override
        public Period getObject(int index) {
            int value = this.get(index);
            int years = value / 12;
            int months = value % 12;
            Period p = new Period();
            return p.plusYears(years).plusMonths(months);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int months = IntervalYearVector.this.data.getInt(index);
            int years = months / 12;
            String yearString = Math.abs(years) == 1 ? " year " : " years ";
            String monthString = Math.abs(months %= 12) == 1 ? " month " : " months ";
            return new StringBuilder().append(years).append(yearString).append(months).append(monthString);
        }
    }

    private class TransferImpl
    implements TransferPair {
        IntervalYearVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new IntervalYearVector(field, IntervalYearVector.this.allocator);
        }

        public TransferImpl(IntervalYearVector to) {
            this.to = to;
        }

        @Override
        public IntervalYearVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalYearVector.this.transferTo(this.to);
        }
    }
}

