/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.IntervalDayReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.joda.time.Period;

public final class IntervalDayVector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public IntervalDayVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 12.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 12);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 12);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 12;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 12;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalDayVector)to);
    }

    public void transferTo(IntervalDayVector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalDayVector.this.getValueCapacity();
            IntervalDayVector.this.valueCount = valueCount;
            int idx = 12 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalDayVector.this.incrementAllocationMonitor();
            } else if (IntervalDayVector.this.allocationMonitor > 0) {
                IntervalDayVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(IntervalDayVector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new IntervalDayReaderImpl(IntervalDayVector.this);
        }

        @Override
        public int getValueCount() {
            return IntervalDayVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void get(int index, IntervalDayHolder holder) {
            int offsetIndex = index * 12;
            holder.days = IntervalDayVector.this.data.getInt(offsetIndex);
            holder.milliseconds = IntervalDayVector.this.data.getInt(offsetIndex + 4);
        }

        public void get(int index, NullableIntervalDayHolder holder) {
            int offsetIndex = index * 12;
            holder.isSet = 1;
            holder.days = IntervalDayVector.this.data.getInt(offsetIndex);
            holder.milliseconds = IntervalDayVector.this.data.getInt(offsetIndex + 4);
        }

        @Override
        public Period getObject(int index) {
            int offsetIndex = index * 12;
            int millis = IntervalDayVector.this.data.getInt(offsetIndex + 4);
            int days = IntervalDayVector.this.data.getInt(offsetIndex);
            Period p = new Period();
            return p.plusDays(days).plusMillis(millis);
        }

        public StringBuilder getAsStringBuilder(int index) {
            int offsetIndex = index * 12;
            int millis = IntervalDayVector.this.data.getInt(offsetIndex + 4);
            int days = IntervalDayVector.this.data.getInt(offsetIndex);
            int hours = millis / 3600000;
            int minutes = (millis %= 3600000) / 60000;
            int seconds = (millis %= 60000) / 1000;
            String dayString = Math.abs(days) == 1 ? " day " : " days ";
            return new StringBuilder().append(days).append(dayString).append(hours).append(":").append(minutes).append(":").append(seconds).append(".").append(millis %= 1000);
        }
    }

    private class TransferImpl
    implements TransferPair {
        IntervalDayVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new IntervalDayVector(field, IntervalDayVector.this.allocator);
        }

        public TransferImpl(IntervalDayVector to) {
            this.to = to;
        }

        @Override
        public IntervalDayVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalDayVector.this.transferTo(this.to);
        }
    }
}

