/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.exec.expr.holders.Decimal38SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.Decimal38SparseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class Decimal38SparseVector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public Decimal38SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 24.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 24);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 24);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 24;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 24;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal38SparseVector)to);
    }

    public void transferTo(Decimal38SparseVector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal38SparseVector.this.getValueCapacity();
            Decimal38SparseVector.this.valueCount = valueCount;
            int idx = 24 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal38SparseVector.this.incrementAllocationMonitor();
            } else if (Decimal38SparseVector.this.allocationMonitor > 0) {
                Decimal38SparseVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Decimal38SparseVector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new Decimal38SparseReaderImpl(Decimal38SparseVector.this);
        }

        @Override
        public int getValueCount() {
            return Decimal38SparseVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void get(int index, Decimal38SparseHolder holder) {
            holder.start = index * 24;
            holder.buffer = Decimal38SparseVector.this.data;
            holder.scale = Decimal38SparseVector.this.getField().getScale();
            holder.precision = Decimal38SparseVector.this.getField().getPrecision();
        }

        public void get(int index, NullableDecimal38SparseHolder holder) {
            holder.isSet = 1;
            holder.start = index * 24;
            holder.buffer = Decimal38SparseVector.this.data;
        }

        @Override
        public BigDecimal getObject(int index) {
            return DecimalUtility.getBigDecimalFromSparse(Decimal38SparseVector.this.data, index * 24, 6, Decimal38SparseVector.this.getField().getScale());
        }
    }

    private class TransferImpl
    implements TransferPair {
        Decimal38SparseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Decimal38SparseVector(field, Decimal38SparseVector.this.allocator);
        }

        public TransferImpl(Decimal38SparseVector to) {
            this.to = to;
        }

        @Override
        public Decimal38SparseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Decimal38SparseVector.this.transferTo(this.to);
        }
    }
}

