/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.Decimal38DenseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class Decimal38DenseVector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public Decimal38DenseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 16.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 16);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 16);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 16;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 16;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal38DenseVector)to);
    }

    public void transferTo(Decimal38DenseVector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal38DenseVector.this.getValueCapacity();
            Decimal38DenseVector.this.valueCount = valueCount;
            int idx = 16 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal38DenseVector.this.incrementAllocationMonitor();
            } else if (Decimal38DenseVector.this.allocationMonitor > 0) {
                Decimal38DenseVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Decimal38DenseVector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new Decimal38DenseReaderImpl(Decimal38DenseVector.this);
        }

        @Override
        public int getValueCount() {
            return Decimal38DenseVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void get(int index, Decimal38DenseHolder holder) {
            holder.start = index * 16;
            holder.buffer = Decimal38DenseVector.this.data;
            holder.scale = Decimal38DenseVector.this.getField().getScale();
            holder.precision = Decimal38DenseVector.this.getField().getPrecision();
        }

        public void get(int index, NullableDecimal38DenseHolder holder) {
            holder.isSet = 1;
            holder.start = index * 16;
            holder.buffer = Decimal38DenseVector.this.data;
        }

        @Override
        public BigDecimal getObject(int index) {
            return DecimalUtility.getBigDecimalFromDense(Decimal38DenseVector.this.data, index * 16, 4, Decimal38DenseVector.this.getField().getScale(), 38, 16);
        }
    }

    private class TransferImpl
    implements TransferPair {
        Decimal38DenseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Decimal38DenseVector(field, Decimal38DenseVector.this.allocator);
        }

        public TransferImpl(Decimal38DenseVector to) {
            this.to = to;
        }

        @Override
        public Decimal38DenseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Decimal38DenseVector.this.transferTo(this.to);
        }
    }
}

