/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.apache.drill.exec.vector.complex.impl.Decimal28SparseReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public final class Decimal28SparseVector
extends BaseDataValueVector
implements FixedWidthVector {
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;

    public Decimal28SparseVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public int getValueCapacity() {
        return (int)((double)this.data.capacity() * 1.0 / 20.0);
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.data = this.allocator.buffer(this.allocationValueCount * 20);
        if (this.data == null) {
            return false;
        }
        this.data.readerIndex(0);
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.data = this.allocator.buffer(valueCount * 20);
        this.data.readerIndex(0);
        this.allocationValueCount = valueCount;
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().setValueCount(this.valueCount).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 20;
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = valueCount * 20;
        this.data = buf.slice(0, len);
        this.data.retain();
        this.data.writerIndex(len);
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata)) : String.format("The field %s doesn't match the provided metadata %s.", this.field, metadata);
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded) : String.format("Expected to load %d bytes but actually loaded %d bytes", metadata.getBufferLength(), loaded);
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Decimal28SparseVector)to);
    }

    public void transferTo(Decimal28SparseVector target) {
        target.data = this.data;
        target.data.retain();
        target.data.writerIndex(this.data.writerIndex());
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = Decimal28SparseVector.this.getValueCapacity();
            Decimal28SparseVector.this.valueCount = valueCount;
            int idx = 20 * valueCount;
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                Decimal28SparseVector.this.incrementAllocationMonitor();
            } else if (Decimal28SparseVector.this.allocationMonitor > 0) {
                Decimal28SparseVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(Decimal28SparseVector.this.data, idx);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        final FieldReader reader;

        public Accessor() {
            this.reader = new Decimal28SparseReaderImpl(Decimal28SparseVector.this);
        }

        @Override
        public int getValueCount() {
            return Decimal28SparseVector.this.valueCount;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public void get(int index, Decimal28SparseHolder holder) {
            holder.start = index * 20;
            holder.buffer = Decimal28SparseVector.this.data;
            holder.scale = Decimal28SparseVector.this.getField().getScale();
            holder.precision = Decimal28SparseVector.this.getField().getPrecision();
        }

        public void get(int index, NullableDecimal28SparseHolder holder) {
            holder.isSet = 1;
            holder.start = index * 20;
            holder.buffer = Decimal28SparseVector.this.data;
        }

        @Override
        public BigDecimal getObject(int index) {
            return DecimalUtility.getBigDecimalFromSparse(Decimal28SparseVector.this.data, index * 20, 5, Decimal28SparseVector.this.getField().getScale());
        }
    }

    private class TransferImpl
    implements TransferPair {
        Decimal28SparseVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new Decimal28SparseVector(field, Decimal28SparseVector.this.allocator);
        }

        public TransferImpl(Decimal28SparseVector to) {
            this.to = to;
        }

        @Override
        public Decimal28SparseVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Decimal28SparseVector.this.transferTo(this.to);
        }
    }
}

