/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VectorTrimmer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitVector
extends BaseDataValueVector
implements FixedWidthVector {
    static final Logger logger = LoggerFactory.getLogger(BitVector.class);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationValueCount = 4096;
    private int allocationMonitor = 0;
    private int valueCapacity;

    public BitVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.field.getAsBuilder().setValueCount(this.valueCount).setBufferLength((int)Math.ceil((double)this.valueCount / 8.0)).build();
    }

    private int getSizeFromCount(int valueCount) {
        return (int)Math.ceil((double)valueCount / 8.0);
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryRuntimeException();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        if (this.allocationMonitor > 10) {
            this.allocationValueCount = Math.max(8, this.allocationValueCount / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            this.allocationValueCount *= 2;
            this.allocationMonitor = 0;
        }
        this.clear();
        this.valueCapacity = this.allocationValueCount;
        int valueSize = this.getSizeFromCount(this.allocationValueCount);
        this.data = this.allocator.buffer(valueSize);
        if (this.data == null) {
            return false;
        }
        this.zeroVector();
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.clear();
        this.valueCapacity = valueCount;
        int valueSize = this.getSizeFromCount(valueCount);
        this.data = this.allocator.buffer(valueSize);
        this.zeroVector();
    }

    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    public int load(int valueCount, DrillBuf buf) {
        this.clear();
        this.valueCount = valueCount;
        int len = this.getSizeFromCount(valueCount);
        this.data = buf.slice(0, len);
        this.data.retain();
        return len;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        assert (this.field.matches(metadata));
        int loaded = this.load(metadata.getValueCount(), buffer);
        assert (metadata.getBufferLength() == loaded);
    }

    public int getValueCapacity() {
        return this.valueCapacity;
    }

    @Override
    public Mutator getMutator() {
        return new Mutator();
    }

    @Override
    public Accessor getAccessor() {
        return new Accessor();
    }

    @Override
    public TransferPair getTransferPair() {
        return new TransferImpl(this.getField());
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((BitVector)to);
    }

    public void transferTo(BitVector target) {
        target.data = this.data;
        target.data.retain();
        target.valueCount = this.valueCount;
        this.clear();
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    public class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        @Override
        public final void setValueCount(int valueCount) {
            int currentValueCapacity = BitVector.this.getValueCapacity();
            BitVector.this.valueCount = valueCount;
            int idx = BitVector.this.getSizeFromCount(valueCount);
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                BitVector.this.incrementAllocationMonitor();
            } else if (BitVector.this.allocationMonitor > 0) {
                BitVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(BitVector.this.data, idx);
        }
    }

    public class Accessor
    extends BaseValueVector.BaseAccessor {
        public final int get(int index) {
            int byteIndex = index >> 3;
            byte b = BitVector.this.data.getByte(byteIndex);
            int bitIndex = index & 7;
            return Long.bitCount((long)b & 1L << bitIndex);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        @Override
        public final Boolean getObject(int index) {
            return new Boolean(this.get(index) != 0);
        }

        @Override
        public final int getValueCount() {
            return BitVector.this.valueCount;
        }
    }

    private class TransferImpl
    implements TransferPair {
        BitVector to;

        public TransferImpl(MaterializedField field) {
            this.to = new BitVector(field, BitVector.this.allocator);
        }

        public TransferImpl(BitVector to) {
            this.to = to;
        }

        @Override
        public BitVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            BitVector.this.transferTo(this.to);
        }
    }
}

