/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseValueVector
implements ValueVector {
    static final Logger logger = LoggerFactory.getLogger(BaseValueVector.class);
    protected final BufferAllocator allocator;
    protected final MaterializedField field;

    BaseValueVector(MaterializedField field, BufferAllocator allocator) {
        this.allocator = allocator;
        this.field = field;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    protected UserBitShared.SerializedField.Builder getMetadataBuilder() {
        return this.getField().getAsBuilder();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Iterators.emptyIterator();
    }

    abstract class BaseMutator
    implements ValueVector.Mutator {
        BaseMutator() {
        }
    }

    static abstract class BaseAccessor
    implements ValueVector.Accessor {
        BaseAccessor() {
        }
    }
}

