/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import com.google.common.collect.Iterators;
import io.netty.buffer.DrillBuf;
import java.util.Iterator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.DeadBuf;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.ValueVector;

public abstract class BaseDataValueVector
extends BaseValueVector {
    protected DrillBuf data;
    protected int valueCount;

    public BaseDataValueVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public void clear() {
        if (this.data == null) {
            this.data = DeadBuf.DEAD_BUFFER;
        }
        if (this.data != DeadBuf.DEAD_BUFFER) {
            this.data.release();
            this.data = this.data.getAllocator().getEmpty();
            this.valueCount = 0;
        }
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] out;
        if (this.valueCount == 0) {
            out = new DrillBuf[]{};
        } else {
            out = new DrillBuf[]{this.data};
            if (clear) {
                this.data.readerIndex(0);
                this.data.retain();
            }
        }
        if (clear) {
            this.clear();
        }
        return out;
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.data.writerIndex();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Iterators.emptyIterator();
    }
}

