/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import org.apache.drill.exec.vector.FixedWidthVector;
import org.apache.drill.exec.vector.RepeatedFixedWidthVector;
import org.apache.drill.exec.vector.RepeatedVariableWidthVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationHelper {
    static final Logger logger = LoggerFactory.getLogger(AllocationHelper.class);

    public static void allocatePrecomputedChildCount(ValueVector v, int valueCount, int bytesPerValue, int childValCount) {
        if (v instanceof FixedWidthVector) {
            ((FixedWidthVector)v).allocateNew(valueCount);
        } else if (v instanceof VariableWidthVector) {
            ((VariableWidthVector)v).allocateNew(valueCount * bytesPerValue, valueCount);
        } else if (v instanceof RepeatedFixedWidthVector) {
            ((RepeatedFixedWidthVector)v).allocateNew(valueCount, childValCount);
        } else if (v instanceof RepeatedVariableWidthVector) {
            ((RepeatedVariableWidthVector)v).allocateNew(childValCount * bytesPerValue, valueCount, childValCount);
        } else {
            v.allocateNew();
        }
    }

    public static void allocate(ValueVector v, int valueCount, int bytesPerValue, int repeatedPerTop) {
        AllocationHelper.allocatePrecomputedChildCount(v, valueCount, bytesPerValue, repeatedPerTop * valueCount);
    }
}

