/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import org.apache.drill.exec.util.TextSerializer;
import org.apache.hadoop.io.Text;

public class JsonStringArrayList<E>
extends ArrayList<E> {
    private static ObjectMapper mapper = new ObjectMapper();

    @Override
    public boolean equals(Object other) {
        if (other instanceof JsonStringArrayList) {
            return this.toString().equals(other.toString());
        }
        if (other instanceof String) {
            return this.toString().equals(other);
        }
        return false;
    }

    @Override
    public final String toString() {
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot serialize array list to JSON string", e);
        }
    }

    static {
        SimpleModule serializer = new SimpleModule("TextSerializer").addSerializer(Text.class, new TextSerializer());
        mapper.registerModule(serializer);
    }
}

