/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.sys.local;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.local.FilePStore;
import org.apache.drill.exec.store.sys.local.LocalEStoreProvider;
import org.apache.drill.exec.store.sys.local.NoWriteLocalPStore;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPStoreProvider
implements PStoreProvider {
    static final Logger logger = LoggerFactory.getLogger(LocalPStoreProvider.class);
    private final Path path;
    private final boolean enableWrite;
    private final ConcurrentMap<PStoreConfig<?>, PStore<?>> pstores;
    private final LocalEStoreProvider estoreProvider;
    private final DrillFileSystem fs;

    public LocalPStoreProvider(DrillConfig config) throws IOException {
        this.path = new Path(config.getString("drill.exec.sys.store.provider.local.path"));
        this.enableWrite = config.getBoolean("drill.exec.sys.store.provider.local.write");
        this.pstores = this.enableWrite ? null : new ConcurrentHashMap();
        this.estoreProvider = new LocalEStoreProvider();
        this.fs = FilePStore.getFileSystem(config, this.path);
    }

    @Override
    public void close() {
    }

    @Override
    public <V> PStore<V> getStore(PStoreConfig<V> storeConfig) throws IOException {
        switch (storeConfig.getMode()) {
            case EPHEMERAL: {
                return this.estoreProvider.getStore(storeConfig);
            }
            case BLOB_PERSISTENT: 
            case PERSISTENT: {
                return this.getPStore(storeConfig);
            }
        }
        throw new IllegalStateException();
    }

    private <V> PStore<V> getPStore(PStoreConfig<V> storeConfig) throws IOException {
        if (this.enableWrite) {
            return new FilePStore<V>(this.fs, this.path, storeConfig);
        }
        NoWriteLocalPStore p = new NoWriteLocalPStore();
        PStore p2 = this.pstores.putIfAbsent(storeConfig, p);
        if (p2 != null) {
            return p2;
        }
        return p;
    }

    @Override
    public void start() {
    }
}

